/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.pisa;

import java.io.IOException;
import java.util.Properties;
import org.moeaframework.algorithm.pisa.PISAAlgorithm;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Settings;
import org.moeaframework.core.Variation;
import org.moeaframework.core.spi.AlgorithmProvider;
import org.moeaframework.core.spi.OperatorFactory;
import org.moeaframework.core.spi.ProviderLookupException;
import org.moeaframework.core.spi.ProviderNotFoundException;

public class PISAAlgorithms
extends AlgorithmProvider {
    protected String getCaseSensitiveSelectorName(String name) {
        for (String selector : Settings.getPISAAlgorithms()) {
            if (!selector.equalsIgnoreCase(name)) continue;
            return selector;
        }
        return null;
    }

    @Override
    public Algorithm getAlgorithm(String name, Properties properties, Problem problem) {
        if ((name = this.getCaseSensitiveSelectorName(name)) != null) {
            if (problem.getNumberOfConstraints() > 0) {
                throw new ProviderNotFoundException(name, new ProviderLookupException("constraints not supported"));
            }
            try {
                Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
                return new PISAAlgorithm(name, problem, variation, properties);
            }
            catch (IOException e) {
                throw new ProviderNotFoundException(name, e);
            }
        }
        return null;
    }
}

