/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.pisa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.moeaframework.core.Settings;

public class State {
    private final File file;
    private static final long pollRate = Settings.getPISAPollRate();
    private static final int numberOfRetries = 5;

    public State(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get() throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.file));
            String line = reader.readLine();
            if (line == null) {
                int n = -1;
                return n;
            }
            int n = Integer.parseInt(line);
            return n;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int state) throws IOException, InterruptedException {
        PrintWriter writer = null;
        int retriesRemaining = 5;
        while (true) {
            try {
                writer = new PrintWriter(new FileWriter(this.file));
                writer.print(state);
                break;
            }
            catch (IOException e) {
                if (--retriesRemaining <= 0) {
                    throw e;
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            Thread.sleep(pollRate);
        }
    }

    public void waitFor(int state) throws IOException, InterruptedException {
        while (!this.file.exists() || this.get() != state) {
            Thread.sleep(pollRate);
        }
    }

    public int waitWhile(int state) throws IOException, InterruptedException {
        int current;
        do {
            Thread.sleep(pollRate);
        } while (!this.file.exists() || (current = this.get()) == state);
        return current;
    }
}

