/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.pso;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.moeaframework.algorithm.AbstractAlgorithm;
import org.moeaframework.algorithm.AlgorithmInitializationException;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.fitness.FitnessBasedArchive;
import org.moeaframework.core.operator.RandomInitialization;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;

public abstract class AbstractPSOAlgorithm
extends AbstractAlgorithm {
    static boolean TESTING_MODE = false;
    protected int swarmSize;
    protected int leaderSize;
    protected Solution[] particles;
    protected Solution[] localBestParticles;
    protected FitnessBasedArchive leaders;
    protected NondominatedPopulation archive;
    protected double[][] velocities;
    protected DominanceComparator leaderComparator;
    protected DominanceComparator dominanceComparator;
    protected Variation mutation;

    public AbstractPSOAlgorithm(Problem problem, int swarmSize, int leaderSize, DominanceComparator leaderComparator, DominanceComparator dominanceComparator, FitnessBasedArchive leaders, NondominatedPopulation archive, Variation mutation) {
        super(problem);
        this.swarmSize = swarmSize;
        this.leaderSize = leaderSize;
        this.leaderComparator = leaderComparator;
        this.dominanceComparator = dominanceComparator;
        this.leaders = leaders;
        this.archive = archive;
        this.mutation = mutation;
        this.particles = new Solution[swarmSize];
        this.localBestParticles = new Solution[swarmSize];
        this.velocities = new double[swarmSize][problem.getNumberOfVariables()];
    }

    protected void updateVelocities() {
        for (int i = 0; i < this.swarmSize; ++i) {
            this.updateVelocity(i);
        }
    }

    protected void updateVelocity(int i) {
        Solution particle = this.particles[i];
        Solution localBestParticle = this.localBestParticles[i];
        Solution leader = this.selectLeader();
        double r1 = PRNG.nextDouble();
        double r2 = PRNG.nextDouble();
        double C1 = PRNG.nextDouble(1.5, 2.0);
        double C2 = PRNG.nextDouble(1.5, 2.0);
        double W = PRNG.nextDouble(0.1, 0.5);
        for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
            double particleValue = EncodingUtils.getReal(particle.getVariable(j));
            double localBestValue = EncodingUtils.getReal(localBestParticle.getVariable(j));
            double leaderValue = EncodingUtils.getReal(leader.getVariable(j));
            this.velocities[i][j] = W * this.velocities[i][j] + C1 * r1 * (localBestValue - particleValue) + C2 * r2 * (leaderValue - particleValue);
        }
    }

    protected void updatePositions() {
        for (int i = 0; i < this.swarmSize; ++i) {
            this.updatePosition(i);
        }
    }

    protected void updatePosition(int i) {
        Solution parent = this.particles[i];
        Solution offspring = parent.copy();
        for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
            RealVariable variable = (RealVariable)offspring.getVariable(j);
            double value = variable.getValue() + this.velocities[i][j];
            if (value < variable.getLowerBound()) {
                value = variable.getLowerBound();
                double[] dArray = this.velocities[i];
                int n = j;
                dArray[n] = dArray[n] * -1.0;
            } else if (value > variable.getUpperBound()) {
                value = variable.getUpperBound();
                double[] dArray = this.velocities[i];
                int n = j;
                dArray[n] = dArray[n] * -1.0;
            }
            variable.setValue(value);
        }
        this.particles[i] = offspring;
    }

    protected Solution selectLeader() {
        Solution leader2;
        Solution leader1 = this.leaders.get(PRNG.nextInt(this.leaders.size()));
        int flag = this.leaderComparator.compare(leader1, leader2 = this.leaders.get(PRNG.nextInt(this.leaders.size())));
        if (flag < 0) {
            return leader1;
        }
        if (flag > 0) {
            return leader2;
        }
        if (PRNG.nextBoolean()) {
            return leader1;
        }
        return leader2;
    }

    protected void updateLocalBest() {
        for (int i = 0; i < this.swarmSize; ++i) {
            int flag = this.dominanceComparator.compare(this.particles[i], this.localBestParticles[i]);
            if (flag > 0) continue;
            this.localBestParticles[i] = this.particles[i];
        }
    }

    protected void mutate() {
        for (int i = 0; i < this.swarmSize; ++i) {
            this.mutate(i);
        }
    }

    protected void mutate(int i) {
        if (this.mutation != null) {
            this.particles[i] = this.mutation.evolve(new Solution[]{this.particles[i]})[0];
        }
    }

    @Override
    public NondominatedPopulation getResult() {
        if (this.archive == null || TESTING_MODE) {
            return new NondominatedPopulation(this.leaders);
        }
        return new NondominatedPopulation(this.archive);
    }

    @Override
    protected void initialize() {
        super.initialize();
        Solution[] initialParticles = new RandomInitialization(this.problem, this.swarmSize).initialize();
        this.evaluateAll(initialParticles);
        for (int i = 0; i < this.swarmSize; ++i) {
            this.particles[i] = initialParticles[i];
            this.localBestParticles[i] = initialParticles[i];
        }
        this.leaders.addAll(initialParticles);
        this.leaders.update();
        if (this.archive != null) {
            this.archive.addAll(initialParticles);
        }
    }

    @Override
    protected void iterate() {
        this.updateVelocities();
        this.updatePositions();
        this.mutate();
        this.evaluateAll(this.particles);
        this.updateLocalBest();
        this.leaders.addAll(this.particles);
        this.leaders.update();
        if (this.archive != null) {
            this.archive.addAll(this.particles);
        }
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        if (!this.isInitialized()) {
            throw new AlgorithmInitializationException((Algorithm)this, "algorithm not initialized");
        }
        List<Solution> particlesList = Arrays.asList(this.particles);
        List<Solution> localBestParticlesList = Arrays.asList(this.localBestParticles);
        ArrayList<Solution> leadersList = new ArrayList<Solution>();
        ArrayList<Solution> archiveList = new ArrayList<Solution>();
        double[][] velocitiesClone = new double[this.velocities.length][];
        for (Solution solution : this.leaders) {
            leadersList.add(solution);
        }
        if (this.archive != null) {
            for (Solution solution : this.archive) {
                archiveList.add(solution);
            }
        }
        for (int i = 0; i < this.velocities.length; ++i) {
            velocitiesClone[i] = (double[])this.velocities[i].clone();
        }
        return new PSOAlgorithmState(this.getNumberOfEvaluations(), particlesList, localBestParticlesList, leadersList, archiveList, velocitiesClone);
    }

    @Override
    public void setState(Object objState) throws NotSerializableException {
        int i;
        super.initialize();
        PSOAlgorithmState state = (PSOAlgorithmState)objState;
        this.numberOfEvaluations = state.getNumberOfEvaluations();
        if (state.getParticles().size() != this.swarmSize) {
            throw new NotSerializableException("swarmSize does not match serialized state");
        }
        for (i = 0; i < this.swarmSize; ++i) {
            this.particles[i] = state.getParticles().get(i);
        }
        for (i = 0; i < this.swarmSize; ++i) {
            this.localBestParticles[i] = state.getLocalBestParticles().get(i);
        }
        this.leaders.addAll(state.getLeaders());
        this.leaders.update();
        if (this.archive != null) {
            this.archive.addAll(state.getArchive());
        }
        for (i = 0; i < this.swarmSize; ++i) {
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                this.velocities[i][j] = state.getVelocities()[i][j];
            }
        }
    }

    private static class PSOAlgorithmState
    implements Serializable {
        private static final long serialVersionUID = -1895823731827106938L;
        private final int numberOfEvaluations;
        private final List<Solution> particles;
        private final List<Solution> localBestParticles;
        private final List<Solution> leaders;
        private final List<Solution> archive;
        private final double[][] velocities;

        public PSOAlgorithmState(int numberOfEvaluations, List<Solution> particles, List<Solution> localBestParticles, List<Solution> leaders, List<Solution> archive, double[][] velocities) {
            this.numberOfEvaluations = numberOfEvaluations;
            this.particles = particles;
            this.localBestParticles = localBestParticles;
            this.leaders = leaders;
            this.archive = archive;
            this.velocities = velocities;
        }

        public int getNumberOfEvaluations() {
            return this.numberOfEvaluations;
        }

        public List<Solution> getParticles() {
            return this.particles;
        }

        public List<Solution> getLocalBestParticles() {
            return this.localBestParticles;
        }

        public List<Solution> getLeaders() {
            return this.leaders;
        }

        public double[][] getVelocities() {
            return this.velocities;
        }

        public List<Solution> getArchive() {
            return this.archive;
        }
    }
}

