/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.pso;

import org.moeaframework.algorithm.pso.AbstractPSOAlgorithm;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.CrowdingComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.fitness.CrowdingDistanceFitnessEvaluator;
import org.moeaframework.core.fitness.FitnessBasedArchive;
import org.moeaframework.core.variable.RealVariable;

public class OMOPSO
extends AbstractPSOAlgorithm {
    private final Variation uniformMutation;
    private final Variation nonUniformMutation;

    public OMOPSO(Problem problem, int swarmSize, int leaderSize, double[] epsilons, double mutationProbability, double mutationPerturbation, int maxIterations) {
        super(problem, swarmSize, leaderSize, new CrowdingComparator(), new ParetoDominanceComparator(), new FitnessBasedArchive(new CrowdingDistanceFitnessEvaluator(), leaderSize), new EpsilonBoxDominanceArchive(epsilons), null);
        this.uniformMutation = new UniformMutation(mutationProbability, mutationPerturbation);
        this.nonUniformMutation = new NonUniformMutation(mutationProbability, mutationPerturbation, maxIterations);
    }

    @Override
    protected void mutate(int i) {
        if (i % 3 == 0) {
            this.particles[i] = this.nonUniformMutation.evolve(new Solution[]{this.particles[i]})[0];
        } else if (i % 3 == 1) {
            this.particles[i] = this.uniformMutation.evolve(new Solution[]{this.particles[i]})[0];
        }
    }

    private class UniformMutation
    implements Variation {
        private final double probability;
        private final double perturbation;

        public UniformMutation(double probability, double perturbation) {
            this.probability = probability;
            this.perturbation = perturbation;
        }

        @Override
        public int getArity() {
            return 1;
        }

        @Override
        public Solution[] evolve(Solution[] parents) {
            Solution offspring = parents[0].copy();
            for (int i = 0; i < offspring.getNumberOfVariables(); ++i) {
                if (!(PRNG.nextDouble() < this.probability)) continue;
                RealVariable variable = (RealVariable)offspring.getVariable(i);
                double value = variable.getValue();
                if ((value += (PRNG.nextDouble() - 0.5) * this.perturbation) < variable.getLowerBound()) {
                    value = variable.getLowerBound();
                } else if (value > variable.getUpperBound()) {
                    value = variable.getUpperBound();
                }
                variable.setValue(value);
            }
            return new Solution[]{offspring};
        }
    }

    private class NonUniformMutation
    implements Variation {
        private final double probability;
        private final double perturbation;
        private final int maxIterations;

        public NonUniformMutation(double probability, double perturbation, int maxIterations) {
            this.probability = probability;
            this.perturbation = perturbation;
            this.maxIterations = maxIterations;
        }

        @Override
        public int getArity() {
            return 1;
        }

        @Override
        public Solution[] evolve(Solution[] parents) {
            Solution offspring = parents[0].copy();
            for (int i = 0; i < offspring.getNumberOfVariables(); ++i) {
                if (!(PRNG.nextDouble() < this.probability)) continue;
                RealVariable variable = (RealVariable)offspring.getVariable(i);
                double value = variable.getValue();
                value = PRNG.nextBoolean() ? (value += this.getDelta(variable.getUpperBound() - value)) : (value += this.getDelta(variable.getLowerBound() - value));
                if (value < variable.getLowerBound()) {
                    value = variable.getLowerBound();
                } else if (value > variable.getUpperBound()) {
                    value = variable.getUpperBound();
                }
                variable.setValue(value);
            }
            return new Solution[]{offspring};
        }

        public double getDelta(double difference) {
            int currentIteration = OMOPSO.this.getNumberOfEvaluations() / OMOPSO.this.swarmSize;
            double fraction = (double)currentIteration / (double)this.maxIterations;
            return difference * (1.0 - Math.pow(PRNG.nextDouble(), Math.pow(1.0 - fraction, this.perturbation)));
        }
    }
}

