/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.pso;

import org.moeaframework.algorithm.pso.AbstractPSOAlgorithm;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.CrowdingComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.fitness.CrowdingDistanceFitnessEvaluator;
import org.moeaframework.core.fitness.FitnessBasedArchive;
import org.moeaframework.core.operator.real.PM;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;

public class SMPSO
extends AbstractPSOAlgorithm {
    private double[] minimumVelocity;
    private double[] maximumVelocity;

    public SMPSO(Problem problem, int swarmSize, int leaderSize, double mutationProbability, double distributionIndex) {
        super(problem, swarmSize, leaderSize, new CrowdingComparator(), new ParetoDominanceComparator(), new FitnessBasedArchive(new CrowdingDistanceFitnessEvaluator(), leaderSize), null, new PM(mutationProbability, distributionIndex));
        this.minimumVelocity = new double[problem.getNumberOfVariables()];
        this.maximumVelocity = new double[problem.getNumberOfVariables()];
        Solution prototypeSolution = problem.newSolution();
        for (int i = 0; i < problem.getNumberOfVariables(); ++i) {
            RealVariable variable = (RealVariable)prototypeSolution.getVariable(i);
            this.maximumVelocity[i] = (variable.getUpperBound() - variable.getLowerBound()) / 2.0;
            this.minimumVelocity[i] = -this.maximumVelocity[i];
        }
    }

    @Override
    protected void updateVelocity(int i) {
        Solution particle = this.particles[i];
        Solution localBestParticle = this.localBestParticles[i];
        Solution leader = this.selectLeader();
        double r1 = PRNG.nextDouble();
        double r2 = PRNG.nextDouble();
        double C1 = PRNG.nextDouble(1.5, 2.5);
        double C2 = PRNG.nextDouble(1.5, 2.5);
        double W = PRNG.nextDouble(0.1, 0.1);
        for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
            double particleValue = EncodingUtils.getReal(particle.getVariable(j));
            double localBestValue = EncodingUtils.getReal(localBestParticle.getVariable(j));
            double leaderValue = EncodingUtils.getReal(leader.getVariable(j));
            double velocity = this.constrictionCoefficient(C1, C2) * (W * this.velocities[i][j] + C1 * r1 * (localBestValue - particleValue) + C2 * r2 * (leaderValue - particleValue));
            if (velocity > this.maximumVelocity[j]) {
                velocity = this.maximumVelocity[j];
            } else if (velocity < this.minimumVelocity[j]) {
                velocity = this.minimumVelocity[j];
            }
            this.velocities[i][j] = velocity;
        }
    }

    protected double constrictionCoefficient(double c1, double c2) {
        double rho = c1 + c2;
        if (rho <= 4.0) {
            return 1.0;
        }
        return 2.0 / (2.0 - rho - Math.sqrt(Math.pow(rho, 2.0) - 4.0 * rho));
    }

    @Override
    protected void mutate(int i) {
        if (i % 6 == 0) {
            this.particles[i] = this.mutation.evolve(new Solution[]{this.particles[i]})[0];
        }
    }
}

