/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.collector;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.moeaframework.core.Settings;

public class Accumulator
implements Serializable {
    private static final long serialVersionUID = -7483439787468468601L;
    private static final String INVALID_KEY = "key not defined in accumulator: {0}";
    private final Map<String, List<Serializable>> data = new HashMap<String, List<Serializable>>();

    public void add(String key, Serializable value) {
        List<Serializable> entries = this.data.get(key);
        if (entries == null) {
            entries = new ArrayList<Serializable>();
            this.data.put(key, entries);
        }
        entries.add(value);
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Serializable get(String key, int index) {
        List<Serializable> entries = this.data.get(key);
        if (entries == null) {
            throw new IllegalArgumentException(MessageFormat.format(INVALID_KEY, key));
        }
        return entries.get(index);
    }

    public int size(String key) {
        List<Serializable> entries = this.data.get(key);
        if (entries == null) {
            throw new IllegalArgumentException(MessageFormat.format(INVALID_KEY, key));
        }
        return entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCSV(File file) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(this.toCSV());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public String toCSV() {
        StringBuilder sb = new StringBuilder();
        boolean firstValue = true;
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        fields.add("NFE");
        if (this.data.containsKey("Elapsed Time")) {
            fields.add("Elapsed Time");
        }
        fields.addAll(this.keySet());
        for (String field : fields) {
            if (!firstValue) {
                sb.append(", ");
            }
            sb.append(StringEscapeUtils.escapeCsv((String)field));
            firstValue = false;
        }
        for (int i = 0; i < this.size("NFE"); ++i) {
            sb.append(Settings.NEW_LINE);
            firstValue = true;
            for (String field : fields) {
                if (!firstValue) {
                    sb.append(", ");
                }
                sb.append(StringEscapeUtils.escapeCsv((String)this.get(field, i).toString()));
                firstValue = false;
            }
        }
        return sb.toString();
    }
}

