/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.collector;

import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.collector.AttachPoint;
import org.moeaframework.analysis.collector.Collector;
import org.moeaframework.core.Variation;
import org.moeaframework.core.operator.AdaptiveMultimethodVariation;
import org.moeaframework.core.operator.CompoundVariation;

public class AdaptiveMultimethodVariationCollector
implements Collector {
    private final AdaptiveMultimethodVariation variation;

    public AdaptiveMultimethodVariationCollector() {
        this(null);
    }

    public AdaptiveMultimethodVariationCollector(AdaptiveMultimethodVariation variation) {
        this.variation = variation;
    }

    @Override
    public void collect(Accumulator accumulator) {
        for (int i = 0; i < this.variation.getNumberOfOperators(); ++i) {
            Variation operator = this.variation.getOperator(i);
            if (operator instanceof CompoundVariation) {
                accumulator.add(((CompoundVariation)operator).getName(), Double.valueOf(this.variation.getOperatorProbability(i)));
                continue;
            }
            accumulator.add(operator.getClass().getSimpleName(), Double.valueOf(this.variation.getOperatorProbability(i)));
        }
    }

    @Override
    public AttachPoint getAttachPoint() {
        return AttachPoint.isSubclass(AdaptiveMultimethodVariation.class);
    }

    @Override
    public Collector attach(Object object) {
        return new AdaptiveMultimethodVariationCollector((AdaptiveMultimethodVariation)object);
    }
}

