/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.collector;

import java.util.ArrayList;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.collector.AttachPoint;
import org.moeaframework.analysis.collector.Collector;
import org.moeaframework.analysis.sensitivity.EpsilonHelper;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Solution;

public class ApproximationSetCollector
implements Collector {
    private final Algorithm algorithm;
    private final double[] epsilon;

    public ApproximationSetCollector() {
        this(null, null);
    }

    public ApproximationSetCollector(double epsilon) {
        this(null, new double[]{epsilon});
    }

    public ApproximationSetCollector(double[] epsilon) {
        this(null, epsilon);
    }

    public ApproximationSetCollector(Algorithm algorithm, double[] epsilon) {
        this.algorithm = algorithm;
        this.epsilon = epsilon;
    }

    @Override
    public AttachPoint getAttachPoint() {
        return AttachPoint.isSubclass(Algorithm.class).and(AttachPoint.not(AttachPoint.isNestedIn(Algorithm.class)));
    }

    @Override
    public Collector attach(Object object) {
        return new ApproximationSetCollector((Algorithm)object, this.epsilon);
    }

    @Override
    public void collect(Accumulator accumulator) {
        ArrayList<Solution> list = new ArrayList<Solution>();
        NondominatedPopulation result = this.algorithm.getResult();
        if (this.epsilon != null) {
            result = EpsilonHelper.convert(result, this.epsilon);
        }
        for (Solution solution : result) {
            list.add(solution);
        }
        accumulator.add("Approximation Set", list);
    }
}

