/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.collector;

import java.util.Stack;

public abstract class AttachPoint {
    protected AttachPoint() {
    }

    public AttachPoint and(final AttachPoint that) {
        return new AttachPoint(){

            @Override
            public boolean matches(Stack<Object> parents, Object object) {
                return AttachPoint.this.matches(parents, object) && that.matches(parents, object);
            }
        };
    }

    public AttachPoint or(final AttachPoint that) {
        return new AttachPoint(){

            @Override
            public boolean matches(Stack<Object> parents, Object object) {
                return AttachPoint.this.matches(parents, object) || that.matches(parents, object);
            }
        };
    }

    public static AttachPoint not(final AttachPoint that) {
        return new AttachPoint(){

            @Override
            public boolean matches(Stack<Object> parents, Object object) {
                return !that.matches(parents, object);
            }
        };
    }

    public static AttachPoint isClass(final Class<?> type) {
        return new AttachPoint(){

            @Override
            public boolean matches(Stack<Object> parents, Object object) {
                return object.getClass().equals(type);
            }
        };
    }

    public static AttachPoint isSubclass(final Class<?> type) {
        return new AttachPoint(){

            @Override
            public boolean matches(Stack<Object> parents, Object object) {
                return type.isInstance(object);
            }
        };
    }

    public static AttachPoint isDeclaredIn(final Class<?> parentType) {
        return new AttachPoint(){

            @Override
            public boolean matches(Stack<Object> parents, Object object) {
                if (parents.isEmpty()) {
                    return false;
                }
                return parentType.isInstance(parents.peek());
            }
        };
    }

    public static AttachPoint isNestedIn(final Class<?> ancestorType) {
        return new AttachPoint(){

            @Override
            public boolean matches(Stack<Object> parents, Object object) {
                for (Object e : parents) {
                    if (!ancestorType.isInstance(e)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public abstract boolean matches(Stack<Object> var1, Object var2);
}

