/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.collector;

import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.collector.AttachPoint;
import org.moeaframework.analysis.collector.Collector;
import org.moeaframework.core.Algorithm;

public class ElapsedTimeCollector
implements Collector {
    private long startTime = System.nanoTime();

    @Override
    public void collect(Accumulator accumulator) {
        double elapsedTime = (double)(System.nanoTime() - this.startTime) * 1.0E-9;
        accumulator.add("Elapsed Time", Double.valueOf(elapsedTime));
    }

    @Override
    public AttachPoint getAttachPoint() {
        return AttachPoint.isSubclass(Algorithm.class).and(AttachPoint.not(AttachPoint.isNestedIn(Algorithm.class)));
    }

    @Override
    public Collector attach(Object object) {
        return new ElapsedTimeCollector();
    }
}

