/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.collector;

import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.collector.AttachPoint;
import org.moeaframework.analysis.collector.Collector;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.EpsilonBoxEvolutionaryAlgorithm;

public class EpsilonProgressCollector
implements Collector {
    private final EpsilonBoxEvolutionaryAlgorithm algorithm;

    public EpsilonProgressCollector() {
        this(null);
    }

    public EpsilonProgressCollector(EpsilonBoxEvolutionaryAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void collect(Accumulator accumulator) {
        EpsilonBoxDominanceArchive archive = this.algorithm.getArchive();
        if (archive != null) {
            accumulator.add("Number of Improvements", Integer.valueOf(archive.getNumberOfImprovements()));
            accumulator.add("Number of Dominating Improvements", Integer.valueOf(archive.getNumberOfDominatingImprovements()));
        }
    }

    @Override
    public AttachPoint getAttachPoint() {
        return AttachPoint.isSubclass(EpsilonBoxEvolutionaryAlgorithm.class);
    }

    @Override
    public Collector attach(Object object) {
        return new EpsilonProgressCollector((EpsilonBoxEvolutionaryAlgorithm)object);
    }
}

