/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.collector;

import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.collector.AttachPoint;
import org.moeaframework.analysis.collector.Collector;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.Indicator;

public class IndicatorCollector
implements Collector {
    private final Indicator indicator;
    private final Algorithm algorithm;
    private final EpsilonBoxDominanceArchive archive;

    public IndicatorCollector(Indicator indicator) {
        this(indicator, null, null);
    }

    public IndicatorCollector(Indicator indicator, EpsilonBoxDominanceArchive archive) {
        this(indicator, archive, null);
    }

    public IndicatorCollector(Indicator indicator, EpsilonBoxDominanceArchive archive, Algorithm algorithm) {
        this.indicator = indicator;
        this.archive = archive;
        this.algorithm = algorithm;
    }

    @Override
    public void collect(Accumulator accumulator) {
        if (this.archive == null) {
            accumulator.add(this.indicator.getClass().getSimpleName(), Double.valueOf(this.indicator.evaluate(this.algorithm.getResult())));
        } else {
            this.archive.clear();
            this.archive.addAll(this.algorithm.getResult());
            accumulator.add(this.indicator.getClass().getSimpleName(), Double.valueOf(this.indicator.evaluate(this.archive)));
        }
    }

    @Override
    public AttachPoint getAttachPoint() {
        return AttachPoint.isSubclass(Algorithm.class).and(AttachPoint.not(AttachPoint.isNestedIn(Algorithm.class)));
    }

    @Override
    public Collector attach(Object object) {
        return new IndicatorCollector(this.indicator, this.archive, (Algorithm)object);
    }
}

