/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.collector;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.moeaframework.algorithm.PeriodicAction;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.collector.Collector;
import org.moeaframework.core.Algorithm;

public class InstrumentedAlgorithm
extends PeriodicAction {
    private final Accumulator accumulator = new Accumulator();
    private final List<Collector> collectors = new ArrayList<Collector>();

    public InstrumentedAlgorithm(Algorithm algorithm, int frequency) {
        super(algorithm, frequency, PeriodicAction.FrequencyType.EVALUATIONS);
    }

    public void addCollector(Collector collector) {
        this.collectors.add(collector);
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    @Override
    public void doAction() {
        this.accumulator.add("NFE", Integer.valueOf(this.algorithm.getNumberOfEvaluations()));
        for (Collector collector : this.collectors) {
            collector.collect(this.accumulator);
        }
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        return new InstrumentedAlgorithmState(super.getState(), this.accumulator);
    }

    @Override
    public void setState(Object objState) throws NotSerializableException {
        InstrumentedAlgorithmState state = (InstrumentedAlgorithmState)objState;
        super.setState(state.getAlgorithmState());
        Accumulator storedAccumulator = state.getAccumulator();
        for (String key : storedAccumulator.keySet()) {
            for (int i = 0; i < storedAccumulator.size(key); ++i) {
                this.accumulator.add(key, storedAccumulator.get(key, i));
            }
        }
    }

    private static class InstrumentedAlgorithmState
    implements Serializable {
        private static final long serialVersionUID = -313598408729472790L;
        private final Serializable algorithmState;
        private final Accumulator accumulator;

        public InstrumentedAlgorithmState(Serializable algorithmState, Accumulator accumulator) {
            this.algorithmState = algorithmState;
            this.accumulator = accumulator;
        }

        public Serializable getAlgorithmState() {
            return this.algorithmState;
        }

        public Accumulator getAccumulator() {
            return this.accumulator;
        }
    }
}

