/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.diagnostics;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.base.Library;
import org.jfree.ui.about.AboutDialog;
import org.jfree.ui.about.ProjectInfo;
import org.moeaframework.Instrumenter;
import org.moeaframework.analysis.diagnostics.ApproximationSetViewer;
import org.moeaframework.analysis.diagnostics.Controller;
import org.moeaframework.analysis.diagnostics.ControllerEvent;
import org.moeaframework.analysis.diagnostics.ControllerListener;
import org.moeaframework.analysis.diagnostics.DiagnosticTool;
import org.moeaframework.analysis.diagnostics.ResultKey;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Settings;
import org.moeaframework.util.Localization;

public class ActionFactory
implements ControllerListener {
    private static Localization localization = Localization.getLocalization(ActionFactory.class);
    private static String EXTENSION = "." + localization.getString("file.extension").toLowerCase();
    private static FileFilter FILTER = new FileNameExtensionFilter(localization.getString("file.extension.description"), localization.getString("file.extension"));
    private final Controller controller;
    private final DiagnosticTool frame;
    private Action saveAction;
    private Action loadAction;
    private Action exitAction;
    private Action showLastTraceAction;
    private Action enableAllIndicatorsAction;
    private Action disableAllIndicatorsAction;
    private Action includeHypervolumeAction;
    private Action includeGenerationalDistanceAction;
    private Action includeInvertedGenerationalDistanceAction;
    private Action includeSpacingAction;
    private Action includeAdditiveEpsilonIndicatorAction;
    private Action includeContributionAction;
    private Action includeR1Action;
    private Action includeR2Action;
    private Action includeR3Action;
    private Action includeEpsilonProgressAction;
    private Action includeAdaptiveMultimethodVariationAction;
    private Action includeAdaptiveTimeContinuationAction;
    private Action includeElapsedTimeAction;
    private Action includePopulationSizeAction;
    private Action includeApproximationSetAction;
    private Action memoryUsageAction;
    private Action runAction;
    private Action cancelAction;
    private Action clearAction;
    private Action showStatisticsAction;
    private Action aboutDialogAction;
    private Action showIndividualTracesAction;
    private Action showQuantilesAction;

    public ActionFactory(DiagnosticTool frame, Controller controller) {
        this.frame = frame;
        this.controller = controller;
        this.initialize();
        controller.addControllerListener(this);
    }

    protected void initialize() {
        this.saveAction = new AbstractAction(){
            private static final long serialVersionUID = -1909996187887919230L;
            {
                this.putValue("Name", localization.getString("action.save.name"));
                this.putValue("ShortDescription", localization.getString("action.save.description"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(FILTER);
                int result = fileChooser.showSaveDialog(ActionFactory.this.frame);
                if (result == 0) {
                    File file = fileChooser.getSelectedFile();
                    if (!file.getName().toLowerCase().endsWith(EXTENSION)) {
                        file = new File(file.getParent(), file.getName() + EXTENSION);
                    }
                    try {
                        ActionFactory.this.controller.saveData(file);
                    }
                    catch (IOException e) {
                        ActionFactory.this.controller.handleException(e);
                    }
                }
            }
        };
        this.loadAction = new AbstractAction(){
            private static final long serialVersionUID = 6667076082827906472L;
            {
                this.putValue("Name", localization.getString("action.load.name"));
                this.putValue("ShortDescription", localization.getString("action.load.description"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(FILTER);
                int result = fileChooser.showOpenDialog(ActionFactory.this.frame);
                if (result == 0) {
                    try {
                        ActionFactory.this.controller.loadData(fileChooser.getSelectedFile());
                    }
                    catch (IOException e) {
                        ActionFactory.this.controller.handleException(e);
                    }
                }
            }
        };
        this.exitAction = new AbstractAction(){
            private static final long serialVersionUID = -8388268233198826720L;
            {
                this.putValue("Name", localization.getString("action.exit.name"));
                this.putValue("ShortDescription", localization.getString("action.exit.description"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ActionFactory.this.frame.dispose();
            }
        };
        this.showLastTraceAction = new AbstractAction(){
            private static final long serialVersionUID = -6068811236087074314L;
            {
                this.putValue("Name", localization.getString("action.showLastTrace.name"));
                this.putValue("ShortDescription", localization.getString("action.showLastTrace.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getShowLastTrace());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setShowLastTrace((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.enableAllIndicatorsAction = new AbstractAction(){
            private static final long serialVersionUID = -6068811236087074314L;
            {
                this.putValue("Name", localization.getString("action.enableAllIndicators.name"));
                this.putValue("ShortDescription", localization.getString("action.enableAllIndicators.description"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.includeHypervolumeAction.putValue("SwingSelectedKey", true);
                ActionFactory.this.includeGenerationalDistanceAction.putValue("SwingSelectedKey", true);
                ActionFactory.this.includeInvertedGenerationalDistanceAction.putValue("SwingSelectedKey", true);
                ActionFactory.this.includeSpacingAction.putValue("SwingSelectedKey", true);
                ActionFactory.this.includeAdditiveEpsilonIndicatorAction.putValue("SwingSelectedKey", true);
                ActionFactory.this.includeContributionAction.putValue("SwingSelectedKey", true);
                ActionFactory.this.includeR1Action.putValue("SwingSelectedKey", true);
                ActionFactory.this.includeR2Action.putValue("SwingSelectedKey", true);
                ActionFactory.this.includeR3Action.putValue("SwingSelectedKey", true);
                ActionFactory.this.controller.setIncludeHypervolume(true);
                ActionFactory.this.controller.setIncludeGenerationalDistance(true);
                ActionFactory.this.controller.setIncludeInvertedGenerationalDistance(true);
                ActionFactory.this.controller.setIncludeSpacing(true);
                ActionFactory.this.controller.setIncludeAdditiveEpsilonIndicator(true);
                ActionFactory.this.controller.setIncludeContribution(true);
                ActionFactory.this.controller.setIncludeR1(true);
                ActionFactory.this.controller.setIncludeR2(true);
                ActionFactory.this.controller.setIncludeR3(true);
            }
        };
        this.disableAllIndicatorsAction = new AbstractAction(){
            private static final long serialVersionUID = 5291581694356532809L;
            {
                this.putValue("Name", localization.getString("action.disableAllIndicators.name"));
                this.putValue("ShortDescription", localization.getString("action.disableAllIndicators.description"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.includeHypervolumeAction.putValue("SwingSelectedKey", false);
                ActionFactory.this.includeGenerationalDistanceAction.putValue("SwingSelectedKey", false);
                ActionFactory.this.includeInvertedGenerationalDistanceAction.putValue("SwingSelectedKey", false);
                ActionFactory.this.includeSpacingAction.putValue("SwingSelectedKey", false);
                ActionFactory.this.includeAdditiveEpsilonIndicatorAction.putValue("SwingSelectedKey", false);
                ActionFactory.this.includeContributionAction.putValue("SwingSelectedKey", false);
                ActionFactory.this.includeR1Action.putValue("SwingSelectedKey", false);
                ActionFactory.this.includeR2Action.putValue("SwingSelectedKey", false);
                ActionFactory.this.includeR3Action.putValue("SwingSelectedKey", false);
                ActionFactory.this.controller.setIncludeHypervolume(false);
                ActionFactory.this.controller.setIncludeGenerationalDistance(false);
                ActionFactory.this.controller.setIncludeInvertedGenerationalDistance(false);
                ActionFactory.this.controller.setIncludeSpacing(false);
                ActionFactory.this.controller.setIncludeAdditiveEpsilonIndicator(false);
                ActionFactory.this.controller.setIncludeContribution(false);
                ActionFactory.this.controller.setIncludeR1(false);
                ActionFactory.this.controller.setIncludeR2(false);
                ActionFactory.this.controller.setIncludeR3(false);
            }
        };
        this.includeHypervolumeAction = new AbstractAction(){
            private static final long serialVersionUID = -8388268233198826720L;
            {
                this.putValue("Name", localization.getString("action.includeHypervolume.name"));
                this.putValue("ShortDescription", localization.getString("action.includeHypervolume.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeHypervolume());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeHypervolume((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeGenerationalDistanceAction = new AbstractAction(){
            private static final long serialVersionUID = 6577840439300886142L;
            {
                this.putValue("Name", localization.getString("action.includeGenerationalDistance.name"));
                this.putValue("ShortDescription", localization.getString("action.includeGenerationalDistance.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeGenerationalDistance());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeGenerationalDistance((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeInvertedGenerationalDistanceAction = new AbstractAction(){
            private static final long serialVersionUID = -4264252375261182056L;
            {
                this.putValue("Name", localization.getString("action.includeInvertedGenerationalDistance.name"));
                this.putValue("ShortDescription", localization.getString("action.includeInvertedGenerationalDistance.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeInvertedGenerationalDistance());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeInvertedGenerationalDistance((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeSpacingAction = new AbstractAction(){
            private static final long serialVersionUID = 3256132970071591253L;
            {
                this.putValue("Name", localization.getString("action.includeSpacing.name"));
                this.putValue("ShortDescription", localization.getString("action.includeSpacing.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeSpacing());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeSpacing((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeAdditiveEpsilonIndicatorAction = new AbstractAction(){
            private static final long serialVersionUID = -4612470190342088537L;
            {
                this.putValue("Name", localization.getString("action.includeAdditiveEpsilonIndicator.name"));
                this.putValue("ShortDescription", localization.getString("action.includeAdditiveEpsilonIndicator.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeAdditiveEpsilonIndicator());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeAdditiveEpsilonIndicator((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeContributionAction = new AbstractAction(){
            private static final long serialVersionUID = 7751303429555416136L;
            {
                this.putValue("Name", localization.getString("action.includeContribution.name"));
                this.putValue("ShortDescription", localization.getString("action.includeContribution.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeContribution());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeContribution((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeR1Action = new AbstractAction(){
            private static final long serialVersionUID = 7307447492866764644L;
            {
                this.putValue("Name", localization.getString("action.includeR1.name"));
                this.putValue("ShortDescription", localization.getString("action.includeR1.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeR1());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeR1((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeR2Action = new AbstractAction(){
            private static final long serialVersionUID = -5385083123364658233L;
            {
                this.putValue("Name", localization.getString("action.includeR2.name"));
                this.putValue("ShortDescription", localization.getString("action.includeR2.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeR2());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeR2((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeR3Action = new AbstractAction(){
            private static final long serialVersionUID = -2777143619264295330L;
            {
                this.putValue("Name", localization.getString("action.includeR3.name"));
                this.putValue("ShortDescription", localization.getString("action.includeR3.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeR3());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeR3((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeEpsilonProgressAction = new AbstractAction(){
            private static final long serialVersionUID = -2514670979923374486L;
            {
                this.putValue("Name", localization.getString("action.includeEpsilonProgress.name"));
                this.putValue("ShortDescription", localization.getString("action.includeEpsilonProgress.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeEpsilonProgress());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeEpsilonProgress((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeAdaptiveMultimethodVariationAction = new AbstractAction(){
            private static final long serialVersionUID = -2295024482426435226L;
            {
                this.putValue("Name", localization.getString("action.includeAdaptiveMultimethodVariation.name"));
                this.putValue("ShortDescription", localization.getString("action.includeAdaptiveMultimethodVariation.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeAdaptiveMultimethodVariation());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeAdaptiveMultimethodVariation((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeAdaptiveTimeContinuationAction = new AbstractAction(){
            private static final long serialVersionUID = 3178255679435336378L;
            {
                this.putValue("Name", localization.getString("action.includeAdaptiveTimeContinuation.name"));
                this.putValue("ShortDescription", localization.getString("action.includeAdaptiveTimeContinuation.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeAdaptiveTimeContinuation());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeAdaptiveTimeContinuation((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeElapsedTimeAction = new AbstractAction(){
            private static final long serialVersionUID = -664733245004881369L;
            {
                this.putValue("Name", localization.getString("action.includeElapsedTime.name"));
                this.putValue("ShortDescription", localization.getString("action.includeElapsedTime.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeElapsedTime());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeElapsedTime((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includePopulationSizeAction = new AbstractAction(){
            private static final long serialVersionUID = 567786863596776287L;
            {
                this.putValue("Name", localization.getString("action.includePopulationSize.name"));
                this.putValue("ShortDescription", localization.getString("action.includePopulationSize.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludePopulationSize());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludePopulationSize((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.includeApproximationSetAction = new AbstractAction(){
            private static final long serialVersionUID = 567786863596776287L;
            {
                this.putValue("Name", localization.getString("action.includeApproximationSet.name"));
                this.putValue("ShortDescription", localization.getString("action.includeApproximationSet.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getIncludeApproximationSet());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setIncludeApproximationSet((Boolean)this.getValue("SwingSelectedKey"));
            }
        };
        this.runAction = new AbstractAction(){
            private static final long serialVersionUID = -3966834246075639069L;
            {
                this.putValue("Name", localization.getString("action.run.name"));
                this.putValue("ShortDescription", localization.getString("action.run.description"));
                this.setEnabled(!ActionFactory.this.controller.isRunning());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.run();
            }
        };
        this.cancelAction = new AbstractAction(){
            private static final long serialVersionUID = 3035060554253471054L;
            {
                this.putValue("Name", localization.getString("action.cancel.name"));
                this.putValue("ShortDescription", localization.getString("action.cancel.description"));
                this.setEnabled(ActionFactory.this.controller.isRunning());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.cancel();
            }
        };
        this.clearAction = new AbstractAction(){
            private static final long serialVersionUID = 3770122212031491835L;
            {
                this.putValue("Name", localization.getString("action.clear.name"));
                this.putValue("ShortDescription", localization.getString("action.clear.description"));
                this.setEnabled(!ActionFactory.this.controller.isRunning());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.clear();
            }
        };
        this.showStatisticsAction = new AbstractAction(){
            private static final long serialVersionUID = 6836221261899470110L;
            {
                this.putValue("Name", localization.getString("action.showStatistics.name"));
                this.putValue("ShortDescription", localization.getString("action.showStatistics.description"));
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.showStatistics();
            }
        };
        this.aboutDialogAction = new AbstractAction(){
            private static final long serialVersionUID = -7768030811303579787L;
            {
                this.putValue("Name", localization.getString("action.about.name"));
                this.putValue("ShortDescription", localization.getString("action.about.description"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Properties properties = new Properties();
                    InputStream stream = null;
                    try {
                        stream = this.getClass().getResourceAsStream("/META-INF/build.properties");
                        properties.load(stream);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    ProjectInfo info = new ProjectInfo(properties.getProperty("name"), properties.getProperty("version"), properties.getProperty("description"), null, properties.getProperty("copyright"), null, ActionFactory.this.loadLicense());
                    info.addLibrary(new Library("Apache Commons CLI", "1.2", "Apache License", null));
                    info.addLibrary(new Library("Apache Commons Codec", "1.8", "Apache License", null));
                    info.addLibrary(new Library("Apache Commons Lang", "3.1", "Apache License", null));
                    info.addLibrary(new Library("Apache Commons Math", "3.4.1", "Apache License", null));
                    info.addLibrary(new Library("JCommon", "1.0.20", "GNU LGPL", null));
                    info.addLibrary(new Library("JFreeChart", "1.0.15", "GNU LGPL", null));
                    info.addLibrary(new Library("JMetal", "4.3", "GNU LGPL", null));
                    info.addLibrary(new Library("MOEAFramework", properties.getProperty("version"), "GNU LGPL", null));
                    AboutDialog dialog = new AboutDialog((Frame)ActionFactory.this.frame, localization.getString("title.about"), info);
                    dialog.setLocationRelativeTo((Component)ActionFactory.this.frame);
                    dialog.setVisible(true);
                }
                catch (Exception ex) {
                    ActionFactory.this.controller.handleException(ex);
                }
            }
        };
        this.showIndividualTracesAction = new AbstractAction(){
            private static final long serialVersionUID = 7197923975477668385L;
            {
                this.putValue("Name", localization.getString("action.showIndividualTraces.name"));
                this.putValue("ShortDescription", localization.getString("action.showIndividualTraces.description"));
                this.putValue("SwingSelectedKey", ActionFactory.this.controller.getShowIndividualTraces());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setShowIndividualTraces(true);
            }
        };
        this.showQuantilesAction = new AbstractAction(){
            private static final long serialVersionUID = -7733483777432591099L;
            {
                this.putValue("Name", localization.getString("action.showQuantiles.name"));
                this.putValue("ShortDescription", localization.getString("action.showQuantiles.description"));
                this.putValue("SwingSelectedKey", !ActionFactory.this.controller.getShowIndividualTraces());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionFactory.this.controller.setShowIndividualTraces(false);
            }
        };
        this.memoryUsageAction = new AbstractAction(){
            private static final long serialVersionUID = -3966834246075639069L;
            {
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        final Timer timer = new Timer(1000, new ActionListener(){
            final double DIVISOR = 1048576.0;

            @Override
            public void actionPerformed(ActionEvent e) {
                long free = Runtime.getRuntime().freeMemory();
                long total = Runtime.getRuntime().totalMemory();
                long max = Runtime.getRuntime().maxMemory();
                double used = (double)(total - free) / 1048576.0;
                double available = (double)max / 1048576.0;
                ActionFactory.this.memoryUsageAction.putValue("Name", localization.getString("text.memory", used, available));
            }
        });
        timer.setRepeats(true);
        timer.setCoalesce(true);
        timer.start();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                timer.stop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadLicense() throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        String line = null;
        boolean isNewParagraph = false;
        try {
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/LGPL-LICENSE")));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) {
                    isNewParagraph = true;
                    continue;
                }
                if (isNewParagraph) {
                    sb.append(Settings.NEW_LINE);
                    sb.append(Settings.NEW_LINE);
                } else {
                    sb.append(' ');
                }
                sb.append(line);
                isNewParagraph = false;
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Action getSaveAction() {
        return this.saveAction;
    }

    public Action getLoadAction() {
        return this.loadAction;
    }

    public Action getExitAction() {
        return this.exitAction;
    }

    public Action getShowLastTraceAction() {
        return this.showLastTraceAction;
    }

    public Action getEnableAllIndicatorsAction() {
        return this.enableAllIndicatorsAction;
    }

    public Action getDisableAllIndicatorsAction() {
        return this.disableAllIndicatorsAction;
    }

    public Action getIncludeHypervolumeAction() {
        return this.includeHypervolumeAction;
    }

    public Action getIncludeGenerationalDistanceAction() {
        return this.includeGenerationalDistanceAction;
    }

    public Action getIncludeInvertedGenerationalDistanceAction() {
        return this.includeInvertedGenerationalDistanceAction;
    }

    public Action getIncludeSpacingAction() {
        return this.includeSpacingAction;
    }

    public Action getIncludeAdditiveEpsilonIndicatorAction() {
        return this.includeAdditiveEpsilonIndicatorAction;
    }

    public Action getIncludeContributionAction() {
        return this.includeContributionAction;
    }

    public Action getIncludeR1Action() {
        return this.includeR1Action;
    }

    public Action getIncludeR2Action() {
        return this.includeR2Action;
    }

    public Action getIncludeR3Action() {
        return this.includeR3Action;
    }

    public Action getIncludeEpsilonProgressAction() {
        return this.includeEpsilonProgressAction;
    }

    public Action getIncludeAdaptiveMultimethodVariationAction() {
        return this.includeAdaptiveMultimethodVariationAction;
    }

    public Action getIncludeAdaptiveTimeContinuationAction() {
        return this.includeAdaptiveTimeContinuationAction;
    }

    public Action getIncludeElapsedTimeAction() {
        return this.includeElapsedTimeAction;
    }

    public Action getIncludePopulationSizeAction() {
        return this.includePopulationSizeAction;
    }

    public Action getIncludeApproximationSetAction() {
        return this.includeApproximationSetAction;
    }

    public Action getMemoryUsageAction() {
        return this.memoryUsageAction;
    }

    public Action getRunAction() {
        return this.runAction;
    }

    public Action getCancelAction() {
        return this.cancelAction;
    }

    public Action getClearAction() {
        return this.clearAction;
    }

    public Action getShowStatisticsAction() {
        return this.showStatisticsAction;
    }

    public Action getAboutDialogAction() {
        return this.aboutDialogAction;
    }

    public Action getShowIndividualTracesAction() {
        return this.showIndividualTracesAction;
    }

    public Action getShowQuantilesAction() {
        return this.showQuantilesAction;
    }

    public Action getShowApproximationSetAction(final ResultKey key) {
        return new AbstractAction(){
            private static final long serialVersionUID = 1680529848835103744L;
            {
                this.putValue("Name", localization.getString("action.showApproximationSet.name"));
                this.putValue("ShortDescription", localization.getString("action.showApproximationSet.description"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                NondominatedPopulation referenceSet = null;
                try {
                    Instrumenter instrumenter = new Instrumenter().withProblem(key.getProblem());
                    referenceSet = instrumenter.getReferenceSet();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ApproximationSetViewer viewer = new ApproximationSetViewer(key.toString(), ActionFactory.this.controller.get(key), referenceSet);
                viewer.setLocationRelativeTo(ActionFactory.this.frame);
                viewer.setIconImages(ActionFactory.this.frame.getIconImages());
                viewer.setVisible(true);
            }
        };
    }

    public Action getSelectAllAction(final JTable table) {
        return new AbstractAction(){
            private static final long serialVersionUID = 8538384599545194314L;
            {
                this.putValue("Name", localization.getString("action.selectAll.name"));
                this.putValue("ShortDescription", localization.getString("action.selectAll.description"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (table.getModel().getRowCount() > 0) {
                    table.getSelectionModel().setValueIsAdjusting(true);
                    table.addRowSelectionInterval(0, table.getModel().getRowCount() - 1);
                    table.getSelectionModel().setValueIsAdjusting(false);
                }
            }
        };
    }

    @Override
    public void controllerStateChanged(ControllerEvent event) {
        if (event.getType().equals((Object)ControllerEvent.Type.STATE_CHANGED)) {
            this.getRunAction().setEnabled(!this.controller.isRunning());
            this.getCancelAction().setEnabled(this.controller.isRunning());
            this.getClearAction().setEnabled(!this.controller.isRunning());
        } else if (event.getType().equals((Object)ControllerEvent.Type.VIEW_CHANGED) || event.getType().equals((Object)ControllerEvent.Type.MODEL_CHANGED)) {
            HashSet<String> problems = new HashSet<String>();
            HashSet<String> algorithms = new HashSet<String>();
            for (ResultKey key : this.frame.getSelectedResults()) {
                problems.add(key.getProblem());
                algorithms.add(key.getAlgorithm());
            }
            this.getShowStatisticsAction().setEnabled(problems.size() == 1 && algorithms.size() > 1);
        }
    }
}

