/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.diagnostics;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.diagnostics.DiagnosticTool;
import org.moeaframework.analysis.diagnostics.ResultKey;
import org.moeaframework.analysis.diagnostics.ResultPlot;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Solution;
import org.moeaframework.util.Localization;

public class ApproximationSetPlot
extends ResultPlot {
    private static final long serialVersionUID = -6915212513300959375L;
    private static Localization localization = Localization.getLocalization(ApproximationSetPlot.class);
    private static final double EPSILON = 0.01;

    public ApproximationSetPlot(DiagnosticTool frame, String metric) {
        super(frame, metric);
        this.setLayout(new BorderLayout());
    }

    @Override
    protected void update() {
        List list;
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (ResultKey key : this.frame.getSelectedResults()) {
            EpsilonBoxDominanceArchive population = new EpsilonBoxDominanceArchive(0.01);
            for (Accumulator accumulator : this.controller.get(key)) {
                if (!accumulator.keySet().contains(this.metric)) continue;
                list = (List)((Object)accumulator.get(this.metric, accumulator.size(this.metric) - 1));
                for (Object object : list) {
                    ((NondominatedPopulation)population).add((Solution)object);
                }
            }
            if (population.isEmpty()) continue;
            XYSeries series = new XYSeries((Comparable)key, false, true);
            for (Solution solution : population) {
                if (solution.getNumberOfObjectives() == 1) {
                    series.add(solution.getObjective(0), solution.getObjective(0));
                    continue;
                }
                if (solution.getNumberOfObjectives() <= 1) continue;
                series.add(solution.getObjective(0), solution.getObjective(1));
            }
            dataset.addSeries(series);
        }
        JFreeChart chart = ChartFactory.createScatterPlot((String)this.metric, (String)localization.getString("text.objective", 1), (String)localization.getString("text.objective", 2), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            Paint paint = this.frame.getPaintHelper().get(dataset.getSeriesKey(i));
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f, 1, 1));
            renderer.setSeriesPaint(i, paint);
            renderer.setSeriesFillPaint(i, paint);
        }
        plot.setRenderer((XYItemRenderer)renderer);
        if (this.controller.getShowLastTrace() && this.controller.getLastAccumulator() != null && this.controller.getLastAccumulator().keySet().contains(this.metric)) {
            XYSeriesCollection dataset2 = new XYSeriesCollection();
            EpsilonBoxDominanceArchive population = new EpsilonBoxDominanceArchive(0.01);
            if (this.controller.getLastAccumulator().keySet().contains(this.metric)) {
                list = (List)((Object)this.controller.getLastAccumulator().get(this.metric, this.controller.getLastAccumulator().size(this.metric) - 1));
                for (Object object : list) {
                    ((NondominatedPopulation)population).add((Solution)object);
                }
            }
            if (!population.isEmpty()) {
                XYSeries series = new XYSeries((Comparable)((Object)localization.getString("text.last")), false, true);
                for (Solution solution : population) {
                    series.add(solution.getObjective(0), solution.getObjective(1));
                }
                dataset2.addSeries(series);
            }
            XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(false, true);
            renderer2.setSeriesPaint(0, (Paint)Color.BLACK);
            plot.setDataset(1, (XYDataset)dataset2);
            plot.setRenderer(1, (XYItemRenderer)renderer2);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        }
        this.removeAll();
        this.add((Component)new ChartPanel(chart), "Center");
        this.revalidate();
        this.repaint();
    }
}

