/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.diagnostics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.diagnostics.PaintHelper;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.util.Localization;

public class ApproximationSetViewer
extends JFrame
implements ChangeListener,
ActionListener,
ChartChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = -7556845366893802202L;
    private static Localization localization = Localization.getLocalization(ApproximationSetViewer.class);
    private List<Accumulator> accumulators;
    private JPanel chartContainer;
    private JSlider slider;
    private Range initialRangeBounds;
    private Range initialDomainBounds;
    private Range zoomRangeBounds;
    private Range zoomDomainBounds;
    private Range referenceRangeBounds;
    private Range referenceDomainBounds;
    private JRadioButton useInitialBounds;
    private JRadioButton useReferenceSetBounds;
    private JRadioButton useDynamicBounds;
    private JRadioButton useZoomBounds;
    private NondominatedPopulation referenceSet;
    private JList seedList;
    private JButton selectAll;
    private JComboBox xAxisSelection;
    private JComboBox yAxisSelection;
    private PaintHelper paintHelper;

    public ApproximationSetViewer(String name, List<Accumulator> accumulators, NondominatedPopulation referenceSet) {
        super(localization.getString("title.approximationSetViewer", name));
        this.accumulators = accumulators;
        this.referenceSet = referenceSet;
        this.setSize(800, 600);
        this.setMinimumSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(2);
        this.initialize();
        this.layoutComponents();
        this.selectAll.doClick();
    }

    protected void initializeReferenceSetBounds() {
        if (this.referenceSet == null) {
            return;
        }
        double domainMin = Double.POSITIVE_INFINITY;
        double domainMax = Double.NEGATIVE_INFINITY;
        double rangeMin = Double.POSITIVE_INFINITY;
        double rangeMax = Double.NEGATIVE_INFINITY;
        for (Solution solution : this.referenceSet) {
            domainMin = Math.min(domainMin, this.getValue(solution, 0));
            domainMax = Math.max(domainMax, this.getValue(solution, 0));
            rangeMin = Math.min(rangeMin, this.getValue(solution, 1));
            rangeMax = Math.max(rangeMax, this.getValue(solution, 1));
        }
        domainMax += domainMax - domainMin;
        rangeMax += rangeMax - rangeMin;
        this.referenceDomainBounds = new Range(domainMin, domainMax);
        this.referenceRangeBounds = new Range(rangeMin, rangeMax);
    }

    protected void initialize() {
        int i;
        int minimumNFE = Integer.MAX_VALUE;
        int maximumNFE = Integer.MIN_VALUE;
        for (Accumulator accumulator : this.accumulators) {
            minimumNFE = Math.min(minimumNFE, (Integer)accumulator.get("NFE", 0));
            maximumNFE = Math.max(maximumNFE, (Integer)accumulator.get("NFE", accumulator.size("NFE") - 1));
        }
        this.slider = new JSlider(minimumNFE, maximumNFE, minimumNFE);
        this.slider.setPaintTicks(true);
        this.slider.setMinorTickSpacing(100);
        this.slider.setMajorTickSpacing(1000);
        this.slider.addChangeListener(this);
        Solution solution = (Solution)((List)((Object)this.accumulators.get(0).get("Approximation Set", 0))).get(0);
        Vector<String> objectives = new Vector<String>();
        for (i = 0; i < solution.getNumberOfObjectives(); ++i) {
            objectives.add(localization.getString("text.objective", i + 1));
        }
        for (i = 0; i < solution.getNumberOfConstraints(); ++i) {
            objectives.add(localization.getString("text.constraint", i + 1));
        }
        for (i = 0; i < solution.getNumberOfVariables(); ++i) {
            objectives.add(localization.getString("text.variable", i + 1));
        }
        this.xAxisSelection = new JComboBox(objectives);
        this.yAxisSelection = new JComboBox(objectives);
        this.xAxisSelection.setSelectedIndex(0);
        this.yAxisSelection.setSelectedIndex(1);
        this.xAxisSelection.addActionListener(this);
        this.yAxisSelection.addActionListener(this);
        this.initializeReferenceSetBounds();
        this.useInitialBounds = new JRadioButton(localization.getString("action.useInitialBounds.name"));
        this.useReferenceSetBounds = new JRadioButton(localization.getString("action.useReferenceSetBounds.name"));
        this.useDynamicBounds = new JRadioButton(localization.getString("action.useDynamicBounds.name"));
        this.useZoomBounds = new JRadioButton(localization.getString("action.useZoom.name"));
        this.useInitialBounds.setToolTipText(localization.getString("action.useInitialBounds.description"));
        this.useReferenceSetBounds.setToolTipText(localization.getString("action.useReferenceSetBounds.description"));
        this.useDynamicBounds.setToolTipText(localization.getString("action.useDynamicBounds.description"));
        this.useZoomBounds.setToolTipText(localization.getString("action.useZoom.description"));
        ButtonGroup rangeButtonGroup = new ButtonGroup();
        rangeButtonGroup.add(this.useInitialBounds);
        rangeButtonGroup.add(this.useReferenceSetBounds);
        rangeButtonGroup.add(this.useDynamicBounds);
        rangeButtonGroup.add(this.useZoomBounds);
        if (this.referenceSet == null) {
            this.useReferenceSetBounds.setEnabled(false);
        }
        this.useInitialBounds.setSelected(true);
        this.useInitialBounds.addActionListener(this);
        this.useReferenceSetBounds.addActionListener(this);
        this.useDynamicBounds.addActionListener(this);
        this.useZoomBounds.addActionListener(this);
        String[] seeds = new String[this.accumulators.size()];
        for (int i2 = 0; i2 < this.accumulators.size(); ++i2) {
            seeds[i2] = localization.getString("text.seed", i2 + 1);
        }
        this.seedList = new JList<String>(seeds);
        this.seedList.addListSelectionListener(this);
        this.selectAll = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -3709557130361259485L;
            {
                this.putValue("Name", localization.getString("action.selectAll.name"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ApproximationSetViewer.this.seedList.getSelectionModel().setSelectionInterval(0, ApproximationSetViewer.this.seedList.getModel().getSize() - 1);
            }
        });
        this.paintHelper = new PaintHelper();
        this.paintHelper.set((Comparable<?>)((Object)localization.getString("text.referenceSet")), Color.BLACK);
        this.chartContainer = new JPanel(new BorderLayout());
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonPane = new JPanel(new FlowLayout(1));
        buttonPane.add(this.useInitialBounds);
        buttonPane.add(this.useReferenceSetBounds);
        buttonPane.add(this.useDynamicBounds);
        buttonPane.add(this.useZoomBounds);
        JPanel objectivePane = new JPanel(new FlowLayout(1));
        objectivePane.add(new JLabel(localization.getString("text.xAxis")));
        objectivePane.add(this.xAxisSelection);
        objectivePane.add(new JLabel(localization.getString("text.yAxis")));
        objectivePane.add(this.yAxisSelection);
        JPanel controlPane = new JPanel(new GridLayout(3, 1));
        controlPane.add(this.slider);
        controlPane.add(buttonPane);
        controlPane.add(objectivePane);
        JPanel rightPane = new JPanel(new BorderLayout());
        rightPane.add((Component)this.chartContainer, "Center");
        rightPane.add((Component)controlPane, "South");
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.setBorder(BorderFactory.createTitledBorder(localization.getString("text.seeds")));
        leftPane.add((Component)new JScrollPane(this.seedList), "Center");
        leftPane.add((Component)this.selectAll, "South");
        leftPane.setMinimumSize(new Dimension(100, 100));
        JSplitPane splitPane = new JSplitPane(1, leftPane, rightPane);
        this.add((Component)splitPane, "Center");
    }

    protected double getValue(Solution solution, int axis) {
        int selection;
        int n = selection = axis == 0 ? this.xAxisSelection.getSelectedIndex() : this.yAxisSelection.getSelectedIndex();
        if (selection < solution.getNumberOfObjectives()) {
            return solution.getObjective(selection);
        }
        if ((selection -= solution.getNumberOfObjectives()) < solution.getNumberOfConstraints()) {
            return solution.getConstraint(selection);
        }
        if ((selection -= solution.getNumberOfConstraints()) < solution.getNumberOfVariables()) {
            if (solution.getVariable(selection) instanceof RealVariable) {
                return ((RealVariable)solution.getVariable(selection)).getValue();
            }
            return 0.0;
        }
        return 0.0;
    }

    protected void update() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (int seedIndex : this.seedList.getSelectedIndices()) {
            int index;
            Accumulator accumulator = this.accumulators.get(seedIndex);
            if (!accumulator.keySet().contains("Approximation Set")) continue;
            for (index = 0; index < accumulator.size("NFE") - 1 && (Integer)accumulator.get("NFE", index) < this.slider.getValue(); ++index) {
            }
            List list = (List)((Object)accumulator.get("Approximation Set", index));
            XYSeries series = new XYSeries((Comparable)((Object)localization.getString("text.seed", seedIndex + 1)), false, true);
            for (Object object : list) {
                Solution solution = (Solution)object;
                series.add(this.getValue(solution, 0), this.getValue(solution, 1));
            }
            dataset.addSeries(series);
        }
        if (this.referenceSet != null) {
            XYSeries series = new XYSeries((Comparable)((Object)localization.getString("text.referenceSet")), false, true);
            for (Solution solution : this.referenceSet) {
                series.add(this.getValue(solution, 0), this.getValue(solution, 1));
            }
            dataset.addSeries(series);
        }
        JFreeChart chart = ChartFactory.createScatterPlot((String)(this.getTitle() + " @ " + this.slider.getValue() + " NFE"), (String)((String)this.xAxisSelection.getSelectedItem()), (String)((String)this.yAxisSelection.getSelectedItem()), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            Paint paint = this.paintHelper.get(dataset.getSeriesKey(i));
            renderer.setSeriesPaint(i, paint);
        }
        plot.setRenderer((XYItemRenderer)renderer);
        if (this.initialRangeBounds == null || this.initialDomainBounds == null) {
            this.initialRangeBounds = plot.getRangeAxis().getRange();
            this.initialDomainBounds = plot.getDomainAxis().getRange();
        }
        if (this.useInitialBounds.isSelected()) {
            plot.getRangeAxis().setRange(this.initialRangeBounds);
            plot.getDomainAxis().setRange(this.initialDomainBounds);
        } else if (this.useZoomBounds.isSelected()) {
            if (this.zoomRangeBounds == null || this.zoomDomainBounds == null) {
                this.zoomRangeBounds = this.initialRangeBounds;
                this.zoomDomainBounds = this.initialDomainBounds;
            }
            plot.getRangeAxis().setRange(this.zoomRangeBounds);
            plot.getDomainAxis().setRange(this.zoomDomainBounds);
        } else if (this.useReferenceSetBounds.isSelected()) {
            if (this.referenceRangeBounds.getLength() > 0.0) {
                plot.getRangeAxis().setRange(this.referenceRangeBounds);
            }
            if (this.referenceDomainBounds.getLength() > 0.0) {
                plot.getDomainAxis().setRange(this.referenceDomainBounds);
            }
        }
        chart.addChangeListener((ChartChangeListener)this);
        this.chartContainer.removeAll();
        this.chartContainer.add((Component)new ChartPanel(chart), "Center");
        this.chartContainer.revalidate();
        this.chartContainer.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.xAxisSelection || e.getSource() == this.yAxisSelection) {
            this.initialRangeBounds = null;
            this.initialDomainBounds = null;
            this.initializeReferenceSetBounds();
        }
        this.update();
    }

    public void chartChanged(ChartChangeEvent e) {
        this.zoomRangeBounds = e.getChart().getXYPlot().getRangeAxis().getRange();
        this.zoomDomainBounds = e.getChart().getXYPlot().getDomainAxis().getRange();
        this.useZoomBounds.setSelected(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.update();
    }
}

