/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.diagnostics;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.moeaframework.Analyzer;
import org.moeaframework.Executor;
import org.moeaframework.Instrumenter;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.diagnostics.ControllerEvent;
import org.moeaframework.analysis.diagnostics.ControllerListener;
import org.moeaframework.analysis.diagnostics.DiagnosticTool;
import org.moeaframework.analysis.diagnostics.ResultKey;
import org.moeaframework.analysis.diagnostics.StatisticalResultsViewer;
import org.moeaframework.analysis.sensitivity.EpsilonHelper;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.util.progress.ProgressEvent;
import org.moeaframework.util.progress.ProgressListener;

public class Controller {
    private final EventListenerSupport<ControllerListener> listeners;
    private final Map<ResultKey, List<Accumulator>> accumulators;
    private Accumulator lastAccumulator;
    private boolean showLastTrace = false;
    private boolean includeHypervolume = true;
    private boolean includeGenerationalDistance = true;
    private boolean includeInvertedGenerationalDistance = true;
    private boolean includeSpacing = true;
    private boolean includeAdditiveEpsilonIndicator = true;
    private boolean includeContribution = true;
    private boolean includeR1 = false;
    private boolean includeR2 = true;
    private boolean includeR3 = false;
    private boolean includeEpsilonProgress = true;
    private boolean includeAdaptiveMultimethodVariation = true;
    private boolean includeAdaptiveTimeContinuation = true;
    private boolean includeElapsedTime = true;
    private boolean includeApproximationSet = true;
    private boolean includePopulationSize = true;
    private volatile int runProgress;
    private volatile int overallProgress;
    private volatile Thread thread;
    private final DiagnosticTool frame;
    private boolean showIndividualTraces;
    private Executor executor;

    public Controller(DiagnosticTool frame) {
        this.frame = frame;
        this.listeners = EventListenerSupport.create(ControllerListener.class);
        this.accumulators = new HashMap<ResultKey, List<Accumulator>>();
    }

    public void addControllerListener(ControllerListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeControllerListener(ControllerListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    protected void fireModelChangedEvent() {
        this.fireEvent(new ControllerEvent(this, ControllerEvent.Type.MODEL_CHANGED));
    }

    protected void fireStateChangedEvent() {
        this.fireEvent(new ControllerEvent(this, ControllerEvent.Type.STATE_CHANGED));
    }

    protected void fireProgressChangedEvent() {
        this.fireEvent(new ControllerEvent(this, ControllerEvent.Type.PROGRESS_CHANGED));
    }

    protected void fireViewChangedEvent() {
        this.fireEvent(new ControllerEvent(this, ControllerEvent.Type.VIEW_CHANGED));
    }

    protected synchronized void fireEvent(final ControllerEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ControllerListener)Controller.this.listeners.fire()).controllerStateChanged(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ResultKey key, Accumulator accumulator) {
        Map<ResultKey, List<Accumulator>> map = this.accumulators;
        synchronized (map) {
            if (!this.accumulators.containsKey(key)) {
                this.accumulators.put(key, new CopyOnWriteArrayList());
            }
            this.accumulators.get(key).add(accumulator);
            this.lastAccumulator = accumulator;
        }
        this.fireModelChangedEvent();
    }

    public void add(String algorithm, String problem, Accumulator accumulator) {
        this.add(new ResultKey(algorithm, problem), accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.accumulators.isEmpty()) {
            return;
        }
        Map<ResultKey, List<Accumulator>> map = this.accumulators;
        synchronized (map) {
            this.accumulators.clear();
            this.frame.getPaintHelper().clear();
            this.lastAccumulator = null;
        }
        this.fireModelChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Accumulator> get(ResultKey key) {
        Map<ResultKey, List<Accumulator>> map = this.accumulators;
        synchronized (map) {
            return Collections.unmodifiableList(this.accumulators.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResultKey> getKeys() {
        Map<ResultKey, List<Accumulator>> map = this.accumulators;
        synchronized (map) {
            return Collections.unmodifiableSet(this.accumulators.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Accumulator getLastAccumulator() {
        Map<ResultKey, List<Accumulator>> map = this.accumulators;
        synchronized (map) {
            return this.lastAccumulator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLastAccumulator() {
        Map<ResultKey, List<Accumulator>> map = this.accumulators;
        synchronized (map) {
            this.lastAccumulator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveData(File file) throws IOException {
        Map<ResultKey, List<Accumulator>> map = this.accumulators;
        synchronized (map) {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(this.accumulators);
            }
            finally {
                if (oos != null) {
                    oos.close();
                }
            }
        }
    }

    public void loadData(File file) throws IOException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(file));
            Map data = (Map)ois.readObject();
            for (Map.Entry entry : data.entrySet()) {
                ResultKey key = (ResultKey)entry.getKey();
                List list = (List)entry.getValue();
                for (Object element : list) {
                    this.add(key, (Accumulator)element);
                }
            }
        }
        catch (StreamCorruptedException e) {
            throw new IOException("This file does not appear to be a data file generated by the diagnostic tool.", e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    protected void updateProgress(int currentEvaluation, int currentSeed, int totalEvaluations, int totalSeeds) {
        this.runProgress = (int)((double)(100 * currentEvaluation) / (double)totalEvaluations);
        this.overallProgress = (int)((double)(100 * currentSeed) / (double)totalSeeds);
        this.fireProgressChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showStatistics() {
        List<ResultKey> selectedResults = this.frame.getSelectedResults();
        String problemName = selectedResults.get(0).getProblem();
        Problem problem = null;
        try {
            problem = ProblemFactory.getInstance().getProblem(problemName);
            double epsilon = EpsilonHelper.getEpsilon(problem);
            Analyzer analyzer = new Analyzer().withProblem(problemName).withEpsilon(epsilon).showAggregate().showStatisticalSignificance();
            if (this.getIncludeHypervolume()) {
                analyzer.includeHypervolume();
            }
            if (this.getIncludeGenerationalDistance()) {
                analyzer.includeGenerationalDistance();
            }
            if (this.getIncludeInvertedGenerationalDistance()) {
                analyzer.includeInvertedGenerationalDistance();
            }
            if (this.getIncludeSpacing()) {
                analyzer.includeSpacing();
            }
            if (this.getIncludeAdditiveEpsilonIndicator()) {
                analyzer.includeAdditiveEpsilonIndicator();
            }
            if (this.getIncludeContribution()) {
                analyzer.includeContribution();
            }
            if (this.getIncludeR1()) {
                analyzer.includeR1();
            }
            if (this.getIncludeR2()) {
                analyzer.includeR2();
            }
            if (this.getIncludeR3()) {
                analyzer.includeR3();
            }
            for (ResultKey key : selectedResults) {
                for (Accumulator accumulator : this.get(key)) {
                    if (!accumulator.keySet().contains("Approximation Set")) continue;
                    EpsilonBoxDominanceArchive population = new EpsilonBoxDominanceArchive(epsilon);
                    List list = (List)((Object)accumulator.get("Approximation Set", accumulator.size("Approximation Set") - 1));
                    for (Object object : list) {
                        ((NondominatedPopulation)population).add((Solution)object);
                    }
                    analyzer.add(key.getAlgorithm(), population);
                }
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            analyzer.printAnalysis(new PrintStream(stream));
            StatisticalResultsViewer viewer = new StatisticalResultsViewer(this, stream.toString());
            viewer.setLocationRelativeTo(this.frame);
            viewer.setIconImages(this.frame.getIconImages());
            viewer.setVisible(true);
        }
        finally {
            if (problem != null) {
                problem.close();
            }
        }
    }

    public void run() {
        if (this.thread != null) {
            System.err.println("job already running");
            return;
        }
        final String problemName = this.frame.getProblem();
        final String algorithmName = this.frame.getAlgorithm();
        final int numberOfEvaluations = this.frame.getNumberOfEvaluations();
        final int numberOfSeeds = this.frame.getNumberOfSeeds();
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Controller.this.updateProgress(0, 0, numberOfEvaluations, numberOfSeeds);
                    Instrumenter instrumenter = new Instrumenter().withFrequency(100).withProblem(problemName);
                    if (Controller.this.getIncludeHypervolume()) {
                        instrumenter.attachHypervolumeCollector();
                    }
                    if (Controller.this.getIncludeGenerationalDistance()) {
                        instrumenter.attachGenerationalDistanceCollector();
                    }
                    if (Controller.this.getIncludeInvertedGenerationalDistance()) {
                        instrumenter.attachInvertedGenerationalDistanceCollector();
                    }
                    if (Controller.this.getIncludeSpacing()) {
                        instrumenter.attachSpacingCollector();
                    }
                    if (Controller.this.getIncludeAdditiveEpsilonIndicator()) {
                        instrumenter.attachAdditiveEpsilonIndicatorCollector();
                    }
                    if (Controller.this.getIncludeContribution()) {
                        instrumenter.attachContributionCollector();
                    }
                    if (Controller.this.getIncludeR1()) {
                        instrumenter.attachR1Collector();
                    }
                    if (Controller.this.getIncludeR2()) {
                        instrumenter.attachR2Collector();
                    }
                    if (Controller.this.getIncludeR3()) {
                        instrumenter.attachR3Collector();
                    }
                    if (Controller.this.getIncludeEpsilonProgress()) {
                        instrumenter.attachEpsilonProgressCollector();
                    }
                    if (Controller.this.getIncludeAdaptiveMultimethodVariation()) {
                        instrumenter.attachAdaptiveMultimethodVariationCollector();
                    }
                    if (Controller.this.getIncludeAdaptiveTimeContinuation()) {
                        instrumenter.attachAdaptiveTimeContinuationCollector();
                    }
                    if (Controller.this.getIncludeElapsedTime()) {
                        instrumenter.attachElapsedTimeCollector();
                    }
                    if (Controller.this.getIncludeApproximationSet()) {
                        instrumenter.attachApproximationSetCollector();
                    }
                    if (Controller.this.getIncludePopulationSize()) {
                        instrumenter.attachPopulationSizeCollector();
                    }
                    Problem problem = null;
                    try {
                        problem = ProblemFactory.getInstance().getProblem(problemName);
                        instrumenter.withEpsilon(EpsilonHelper.getEpsilon(problem));
                    }
                    finally {
                        if (problem != null) {
                            problem.close();
                        }
                    }
                    ProgressListener listener = new ProgressListener(){

                        @Override
                        public void progressUpdate(ProgressEvent event) {
                            Controller.this.updateProgress(event.getCurrentNFE(), event.getCurrentSeed(), event.getMaxNFE(), event.getTotalSeeds());
                            if (event.isSeedFinished()) {
                                Executor executor = event.getExecutor();
                                Instrumenter instrumenter = executor.getInstrumenter();
                                Controller.this.add(algorithmName, problemName, instrumenter.getLastAccumulator());
                            }
                        }
                    };
                    Controller.this.executor = new Executor().withSameProblemAs(instrumenter).withInstrumenter(instrumenter).withAlgorithm(algorithmName).withMaxEvaluations(numberOfEvaluations).withProgressListener(listener);
                    Controller.this.executor.runSeeds(numberOfSeeds);
                }
                catch (Exception e) {
                    Controller.this.handleException(e);
                }
                finally {
                    Controller.this.thread = null;
                    Controller.this.fireStateChangedEvent();
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
        this.fireStateChangedEvent();
    }

    public void cancel() {
        if (this.executor != null) {
            this.executor.cancel();
        }
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    public boolean getShowLastTrace() {
        return this.showLastTrace;
    }

    public void setShowLastTrace(boolean showLastTrace) {
        this.showLastTrace = showLastTrace;
        this.fireViewChangedEvent();
    }

    public boolean getIncludeHypervolume() {
        return this.includeHypervolume;
    }

    public void setIncludeHypervolume(boolean includeHypervolume) {
        this.includeHypervolume = includeHypervolume;
    }

    public boolean getIncludeGenerationalDistance() {
        return this.includeGenerationalDistance;
    }

    public void setIncludeGenerationalDistance(boolean includeGenerationalDistance) {
        this.includeGenerationalDistance = includeGenerationalDistance;
    }

    public boolean getIncludeInvertedGenerationalDistance() {
        return this.includeInvertedGenerationalDistance;
    }

    public void setIncludeInvertedGenerationalDistance(boolean includeInvertedGenerationalDistance) {
        this.includeInvertedGenerationalDistance = includeInvertedGenerationalDistance;
    }

    public boolean getIncludeSpacing() {
        return this.includeSpacing;
    }

    public void setIncludeSpacing(boolean includeSpacing) {
        this.includeSpacing = includeSpacing;
    }

    public boolean getIncludeAdditiveEpsilonIndicator() {
        return this.includeAdditiveEpsilonIndicator;
    }

    public void setIncludeAdditiveEpsilonIndicator(boolean includeAdditiveEpsilonIndicator) {
        this.includeAdditiveEpsilonIndicator = includeAdditiveEpsilonIndicator;
    }

    public boolean getIncludeContribution() {
        return this.includeContribution;
    }

    public void setIncludeContribution(boolean includeContribution) {
        this.includeContribution = includeContribution;
    }

    public boolean getIncludeR1() {
        return this.includeR1;
    }

    public void setIncludeR1(boolean includeR1) {
        this.includeR1 = includeR1;
    }

    public boolean getIncludeR2() {
        return this.includeR2;
    }

    public void setIncludeR2(boolean includeR2) {
        this.includeR2 = includeR2;
    }

    public boolean getIncludeR3() {
        return this.includeR3;
    }

    public void setIncludeR3(boolean includeR3) {
        this.includeR3 = includeR3;
    }

    public boolean getIncludeEpsilonProgress() {
        return this.includeEpsilonProgress;
    }

    public void setIncludeEpsilonProgress(boolean includeEpsilonProgress) {
        this.includeEpsilonProgress = includeEpsilonProgress;
    }

    public boolean getIncludeAdaptiveMultimethodVariation() {
        return this.includeAdaptiveMultimethodVariation;
    }

    public void setIncludeAdaptiveMultimethodVariation(boolean includeAdaptiveMultimethodVariation) {
        this.includeAdaptiveMultimethodVariation = includeAdaptiveMultimethodVariation;
    }

    public boolean getIncludeAdaptiveTimeContinuation() {
        return this.includeAdaptiveTimeContinuation;
    }

    public void setIncludeAdaptiveTimeContinuation(boolean includeAdaptiveTimeContinuation) {
        this.includeAdaptiveTimeContinuation = includeAdaptiveTimeContinuation;
    }

    public boolean getIncludeElapsedTime() {
        return this.includeElapsedTime;
    }

    public void setIncludeElapsedTime(boolean includeElapsedTime) {
        this.includeElapsedTime = includeElapsedTime;
    }

    public boolean getIncludeApproximationSet() {
        return this.includeApproximationSet;
    }

    public void setIncludeApproximationSet(boolean includeApproximationSet) {
        this.includeApproximationSet = includeApproximationSet;
    }

    public boolean getIncludePopulationSize() {
        return this.includePopulationSize;
    }

    public void setIncludePopulationSize(boolean includePopulationSize) {
        this.includePopulationSize = includePopulationSize;
    }

    public int getRunProgress() {
        return this.runProgress;
    }

    public int getOverallProgress() {
        return this.overallProgress;
    }

    public boolean getShowIndividualTraces() {
        return this.showIndividualTraces;
    }

    public void setShowIndividualTraces(boolean showIndividualTraces) {
        if (this.showIndividualTraces != showIndividualTraces) {
            this.showIndividualTraces = showIndividualTraces;
            this.fireViewChangedEvent();
        }
    }

    protected void handleException(Exception e) {
        String message;
        e.printStackTrace();
        String string = message = e.getMessage() == null ? e.toString() : e.getMessage();
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            message = message + " - " + e.getCause().getMessage();
        }
        JOptionPane.showMessageDialog(this.frame, message, "Error", 0);
    }
}

