/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.diagnostics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.diagnostics.ActionFactory;
import org.moeaframework.analysis.diagnostics.ApproximationSetPlot;
import org.moeaframework.analysis.diagnostics.Controller;
import org.moeaframework.analysis.diagnostics.ControllerEvent;
import org.moeaframework.analysis.diagnostics.ControllerListener;
import org.moeaframework.analysis.diagnostics.EmptyPlot;
import org.moeaframework.analysis.diagnostics.LinePlot;
import org.moeaframework.analysis.diagnostics.PaintHelper;
import org.moeaframework.analysis.diagnostics.ResultKey;
import org.moeaframework.analysis.diagnostics.ResultPlot;
import org.moeaframework.analysis.diagnostics.SortedListModel;
import org.moeaframework.core.Settings;
import org.moeaframework.util.Localization;

public class DiagnosticTool
extends JFrame
implements ListSelectionListener,
ControllerListener {
    private static final long serialVersionUID = -8770087330810075627L;
    private static Localization localization = Localization.getLocalization(DiagnosticTool.class);
    private Controller controller;
    private JList metricList;
    private SortedListModel<ResultKey> resultListModel;
    private SortedListModel<String> metricListModel;
    private JPanel chartContainer;
    private JTable resultTable;
    private AbstractTableModel resultTableModel;
    private JButton selectAll;
    private JButton showStatistics;
    private JComboBox algorithm;
    private JComboBox problem;
    private JSpinner numberOfSeeds;
    private JSpinner numberOfEvaluations;
    private JButton run;
    private JButton cancel;
    private JButton clear;
    private JProgressBar runProgress;
    private JProgressBar overallProgress;
    private ActionFactory actionFactory;
    private PaintHelper paintHelper;

    public DiagnosticTool() {
        super(localization.getString("title.diagnosticTool"));
        this.setSize(800, 600);
        this.setMinimumSize(new Dimension(800, 600));
        this.setExtendedState(6);
        this.setDefaultCloseOperation(2);
        this.initialize();
        this.layoutMenu();
        this.layoutComponents();
    }

    protected void initialize() {
        this.controller = new Controller(this);
        this.controller.addControllerListener(this);
        this.actionFactory = new ActionFactory(this, this.controller);
        this.resultListModel = new SortedListModel();
        this.metricListModel = new SortedListModel();
        this.metricList = new JList<String>(this.metricListModel);
        this.paintHelper = new PaintHelper();
        this.chartContainer = new JPanel();
        this.metricList.addListSelectionListener(this);
        this.resultTableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -4148463449906184742L;

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return localization.getString("text.algorithm");
                    }
                    case 1: {
                        return localization.getString("text.problem");
                    }
                    case 2: {
                        return localization.getString("text.numberOfSeeds");
                    }
                }
                throw new IllegalStateException();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                return DiagnosticTool.this.resultListModel.getSize();
            }

            @Override
            public Object getValueAt(int row, int column) {
                ResultKey key = (ResultKey)DiagnosticTool.this.resultListModel.getElementAt(row);
                switch (column) {
                    case 0: {
                        return key.getAlgorithm();
                    }
                    case 1: {
                        return key.getProblem();
                    }
                    case 2: {
                        return DiagnosticTool.this.controller.get(key).size();
                    }
                }
                throw new IllegalStateException();
            }
        };
        this.resultTable = new JTable(this.resultTableModel);
        this.resultTable.getSelectionModel().addListSelectionListener(this);
        this.resultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int index = DiagnosticTool.this.resultTable.rowAtPoint(e.getPoint());
                    boolean containsSet = false;
                    if (index == -1) {
                        return;
                    }
                    ResultKey key = (ResultKey)DiagnosticTool.this.resultListModel.getElementAt(index);
                    for (Accumulator accumulator : DiagnosticTool.this.controller.get(key)) {
                        if (!accumulator.keySet().contains("Approximation Set")) continue;
                        containsSet = true;
                    }
                    if (!containsSet) {
                        return;
                    }
                    JPopupMenu popupMenu = new JPopupMenu();
                    popupMenu.add(new JMenuItem(DiagnosticTool.this.actionFactory.getShowApproximationSetAction((ResultKey)DiagnosticTool.this.resultListModel.getElementAt(index))));
                    popupMenu.show(DiagnosticTool.this.resultTable, e.getX(), e.getY());
                }
            }
        });
        this.selectAll = new JButton(this.actionFactory.getSelectAllAction(this.resultTable));
        this.showStatistics = new JButton(this.actionFactory.getShowStatisticsAction());
        HashSet<String> algorithmNames = new HashSet<String>();
        for (String algorithm : Settings.getDiagnosticToolAlgorithms()) {
            algorithmNames.add(algorithm);
        }
        for (String algorithm : Settings.getPISAAlgorithms()) {
            algorithmNames.add(algorithm);
        }
        ArrayList sortedAlgorithmNames = new ArrayList(algorithmNames);
        Collections.sort(sortedAlgorithmNames);
        this.algorithm = new JComboBox<Object>(sortedAlgorithmNames.toArray());
        HashSet<String> problemNames = new HashSet<String>();
        for (String problem : Settings.getDiagnosticToolProblems()) {
            problemNames.add(problem);
        }
        for (String problem : Settings.getProblems()) {
            problemNames.add(problem);
        }
        ArrayList sortedProblemNames = new ArrayList(problemNames);
        Collections.sort(sortedProblemNames);
        this.problem = new JComboBox<Object>(sortedProblemNames.toArray());
        this.numberOfSeeds = new JSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 10));
        this.numberOfEvaluations = new JSpinner(new SpinnerNumberModel(10000, 500, Integer.MAX_VALUE, 1000));
        this.run = new JButton(this.actionFactory.getRunAction());
        this.cancel = new JButton(this.actionFactory.getCancelAction());
        this.clear = new JButton(this.actionFactory.getClearAction());
        this.runProgress = new JProgressBar();
        this.overallProgress = new JProgressBar();
        this.algorithm.setEditable(true);
        this.problem.setEditable(true);
    }

    protected void layoutMenu() {
        JMenu file = new JMenu(localization.getString("menu.file"));
        file.add(new JMenuItem(this.actionFactory.getSaveAction()));
        file.add(new JMenuItem(this.actionFactory.getLoadAction()));
        file.addSeparator();
        file.add(new JMenuItem(this.actionFactory.getExitAction()));
        JMenu view = new JMenu(localization.getString("menu.view"));
        JRadioButtonMenuItem individualTraces = new JRadioButtonMenuItem(this.actionFactory.getShowIndividualTracesAction());
        JRadioButtonMenuItem quantiles = new JRadioButtonMenuItem(this.actionFactory.getShowQuantilesAction());
        ButtonGroup traceGroup = new ButtonGroup();
        traceGroup.add(individualTraces);
        traceGroup.add(quantiles);
        view.add(individualTraces);
        view.add(quantiles);
        view.addSeparator();
        view.add(new JCheckBoxMenuItem(this.actionFactory.getShowLastTraceAction()));
        JMenu metrics = new JMenu(localization.getString("menu.collect"));
        metrics.add(new JMenuItem(this.actionFactory.getEnableAllIndicatorsAction()));
        metrics.add(new JMenuItem(this.actionFactory.getDisableAllIndicatorsAction()));
        metrics.addSeparator();
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeHypervolumeAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeGenerationalDistanceAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeInvertedGenerationalDistanceAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeSpacingAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeAdditiveEpsilonIndicatorAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeContributionAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeR1Action()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeR2Action()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeR3Action()));
        metrics.addSeparator();
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeEpsilonProgressAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeAdaptiveMultimethodVariationAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeAdaptiveTimeContinuationAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeElapsedTimeAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludePopulationSizeAction()));
        metrics.add(new JCheckBoxMenuItem(this.actionFactory.getIncludeApproximationSetAction()));
        JMenu help = new JMenu(localization.getString("menu.help"));
        help.add(new JMenuItem(this.actionFactory.getAboutDialogAction()));
        JMenu usage = new JMenu(this.actionFactory.getMemoryUsageAction());
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(file);
        menuBar.add(view);
        menuBar.add(metrics);
        menuBar.add(help);
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(usage);
        this.setJMenuBar(menuBar);
    }

    protected void layoutComponents() {
        GridBagConstraints label = new GridBagConstraints();
        label.gridx = 0;
        label.gridy = -1;
        label.anchor = 13;
        label.insets = new Insets(0, 5, 5, 25);
        GridBagConstraints field = new GridBagConstraints();
        field.gridx = 1;
        field.gridy = -1;
        field.fill = 2;
        field.weightx = 1.0;
        field.insets = new Insets(0, 0, 5, 5);
        GridBagConstraints button = new GridBagConstraints();
        button.gridx = 0;
        button.gridwidth = 2;
        button.fill = 2;
        button.insets = new Insets(0, 0, 5, 0);
        JPanel analysisPane = new JPanel(new FlowLayout(1));
        analysisPane.add(this.selectAll);
        analysisPane.add(this.showStatistics);
        JPanel resultPane = new JPanel(new BorderLayout());
        resultPane.setBorder(BorderFactory.createTitledBorder(localization.getString("text.displayedResults")));
        resultPane.add((Component)new JScrollPane(this.resultTable), "Center");
        resultPane.add((Component)analysisPane, "South");
        resultPane.setMinimumSize(new Dimension(100, 100));
        JPanel metricPane = new JPanel(new BorderLayout());
        metricPane.setBorder(BorderFactory.createTitledBorder(localization.getString("text.displayedMetrics")));
        metricPane.add((Component)new JScrollPane(this.metricList), "Center");
        metricPane.setMinimumSize(new Dimension(100, 100));
        JPanel selectionPane = new JPanel(new GridLayout(2, 1));
        selectionPane.add(resultPane);
        selectionPane.add(metricPane);
        JPanel buttonPane = new JPanel(new FlowLayout(1));
        buttonPane.add(this.run);
        buttonPane.add(this.cancel);
        buttonPane.add(this.clear);
        JPanel controlPane = new JPanel(new GridBagLayout());
        controlPane.setBorder(BorderFactory.createTitledBorder(localization.getString("text.controls")));
        controlPane.add((Component)new JLabel(localization.getString("text.algorithm") + ":"), label);
        controlPane.add((Component)this.algorithm, field);
        controlPane.add((Component)new JLabel(localization.getString("text.problem") + ":"), label);
        controlPane.add((Component)this.problem, field);
        controlPane.add((Component)new JLabel(localization.getString("text.numberOfSeeds") + ":"), label);
        controlPane.add((Component)this.numberOfSeeds, field);
        controlPane.add((Component)new JLabel(localization.getString("text.numberOfEvaluations") + ":"), label);
        controlPane.add((Component)this.numberOfEvaluations, field);
        controlPane.add((Component)buttonPane, button);
        controlPane.add((Component)new JPanel(), button);
        controlPane.add((Component)new JLabel(localization.getString("text.runProgress") + ":"), label);
        controlPane.add((Component)this.runProgress, field);
        controlPane.add((Component)new JLabel(localization.getString("text.overallProgress") + ":"), label);
        controlPane.add((Component)this.overallProgress, field);
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.add(controlPane);
        controls.add(selectionPane);
        controls.setMinimumSize(controlPane.getPreferredSize());
        controls.setPreferredSize(controlPane.getPreferredSize());
        JSplitPane splitPane = new JSplitPane(1, controls, this.chartContainer);
        splitPane.setDividerLocation(-1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)splitPane, "Center");
    }

    protected void updateModel() {
        List<ResultKey> selectedResults = this.getSelectedResults();
        List<String> selectedMetrics = this.getSelectedMetrics();
        boolean selectAllResults = false;
        boolean selectFirstMetric = false;
        if (selectedResults.size() == this.resultListModel.getSize()) {
            selectAllResults = true;
        }
        if (selectedMetrics.size() == 0 && this.metricListModel.getSize() == 0) {
            selectFirstMetric = true;
        }
        this.resultListModel.addAll(this.controller.getKeys());
        for (ResultKey key : this.controller.getKeys()) {
            for (Accumulator accumulator : this.controller.get(key)) {
                this.metricListModel.addAll(accumulator.keySet());
            }
        }
        this.metricList.getSelectionModel().removeListSelectionListener(this);
        this.metricList.clearSelection();
        if (selectFirstMetric) {
            this.metricList.setSelectedIndex(0);
        } else {
            for (String metric : selectedMetrics) {
                int index = this.metricListModel.getIndexOf(metric);
                this.metricList.getSelectionModel().addSelectionInterval(index, index);
            }
        }
        this.metricList.getSelectionModel().addListSelectionListener(this);
        this.resultTable.getSelectionModel().removeListSelectionListener(this);
        this.resultTableModel.fireTableDataChanged();
        if (selectAllResults && selectedResults.size() < this.resultListModel.getSize()) {
            this.resultTable.getSelectionModel().addSelectionInterval(0, this.resultListModel.getSize() - 1);
        } else {
            for (ResultKey key : selectedResults) {
                int index = this.resultListModel.getIndexOf(key);
                this.resultTable.getSelectionModel().addSelectionInterval(index, index);
            }
        }
        this.resultTable.getSelectionModel().addListSelectionListener(this);
    }

    public Controller getController() {
        return this.controller;
    }

    public PaintHelper getPaintHelper() {
        return this.paintHelper;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.controller.fireViewChangedEvent();
    }

    protected void clear() {
        this.resultListModel.clear();
        this.resultTable.getSelectionModel().clearSelection();
        this.resultTableModel.fireTableDataChanged();
        this.metricListModel.clear();
        this.metricList.getSelectionModel().clearSelection();
        this.paintHelper.clear();
        this.chartContainer.removeAll();
        this.chartContainer.revalidate();
        this.chartContainer.repaint();
    }

    protected void updateChartLayout() {
        this.chartContainer.removeAll();
        List<String> selectedMetrics = this.getSelectedMetrics();
        if (selectedMetrics.size() > 0) {
            if (selectedMetrics.size() <= 1) {
                this.chartContainer.setLayout(new GridLayout(1, 1));
            } else if (selectedMetrics.size() <= 2) {
                this.chartContainer.setLayout(new GridLayout(2, 1));
            } else if (selectedMetrics.size() <= 4) {
                this.chartContainer.setLayout(new GridLayout(2, 2));
            } else if (selectedMetrics.size() <= 6) {
                this.chartContainer.setLayout(new GridLayout(3, 2));
            } else {
                this.chartContainer.setLayout(new GridLayout((int)Math.ceil((double)selectedMetrics.size() / 3.0), 3));
            }
            GridLayout layout = (GridLayout)this.chartContainer.getLayout();
            int spaces = layout.getRows() * layout.getColumns();
            for (int i = 0; i < Math.max(spaces, selectedMetrics.size()); ++i) {
                if (i < selectedMetrics.size()) {
                    this.chartContainer.add(this.createChart(selectedMetrics.get(i)));
                    continue;
                }
                this.chartContainer.add(new EmptyPlot(this));
            }
        }
        this.chartContainer.revalidate();
    }

    protected List<String> getSelectedMetrics() {
        ArrayList<String> selectedMetrics = new ArrayList<String>();
        for (int index : this.metricList.getSelectedIndices()) {
            selectedMetrics.add((String)this.metricListModel.getElementAt(index));
        }
        return selectedMetrics;
    }

    protected List<ResultKey> getSelectedResults() {
        ArrayList<ResultKey> selectedResults = new ArrayList<ResultKey>();
        for (int index : this.resultTable.getSelectedRows()) {
            selectedResults.add((ResultKey)this.resultListModel.getElementAt(index));
        }
        return selectedResults;
    }

    protected String getAlgorithm() {
        return (String)this.algorithm.getSelectedItem();
    }

    protected String getProblem() {
        return (String)this.problem.getSelectedItem();
    }

    protected int getNumberOfEvaluations() {
        return (Integer)this.numberOfEvaluations.getValue();
    }

    protected int getNumberOfSeeds() {
        return (Integer)this.numberOfSeeds.getValue();
    }

    protected ResultPlot createChart(String metric) {
        if (metric.equals("Approximation Set")) {
            return new ApproximationSetPlot(this, metric);
        }
        return new LinePlot(this, metric);
    }

    @Override
    public void controllerStateChanged(ControllerEvent event) {
        if (event.getType().equals((Object)ControllerEvent.Type.MODEL_CHANGED)) {
            if (this.controller.getKeys().isEmpty()) {
                this.clear();
            } else {
                this.updateModel();
            }
        } else if (event.getType().equals((Object)ControllerEvent.Type.PROGRESS_CHANGED)) {
            this.runProgress.setValue(this.controller.getRunProgress());
            this.overallProgress.setValue(this.controller.getOverallProgress());
        } else if (event.getType().equals((Object)ControllerEvent.Type.VIEW_CHANGED)) {
            this.updateChartLayout();
        }
    }

    @Override
    public void dispose() {
        this.controller.cancel();
        super.dispose();
    }
}

