/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.diagnostics;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.LineBorder;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.diagnostics.DiagnosticTool;
import org.moeaframework.analysis.diagnostics.ResultKey;
import org.moeaframework.analysis.diagnostics.ResultPlot;
import org.moeaframework.util.Localization;

public class LinePlot
extends ResultPlot {
    private static final long serialVersionUID = -6265976590259977358L;
    private static Localization localization = Localization.getLocalization(LinePlot.class);
    private final int RESOLUTION = 500;

    public LinePlot(DiagnosticTool frame, String metric) {
        super(frame, metric);
        this.setLayout(new BorderLayout());
    }

    protected void generateIndividualSeries(ResultKey key, DefaultTableXYDataset dataset) {
        for (Accumulator accumulator : this.controller.get(key)) {
            if (!accumulator.keySet().contains(this.metric)) continue;
            XYSeries series = new XYSeries((Comparable)key, false, false);
            for (int i = 0; i < accumulator.size(this.metric); ++i) {
                series.add((Number)accumulator.get("NFE", i), (Number)accumulator.get(this.metric, i));
            }
            dataset.addSeries(series);
        }
    }

    protected void generateQuantileSeries(ResultKey key, YIntervalSeriesCollection dataset) {
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        for (Accumulator accumulator : this.controller.get(key)) {
            if (!accumulator.keySet().contains(this.metric)) continue;
            for (int i = 0; i < accumulator.size(this.metric); ++i) {
                dataPoints.add(new DataPoint((Integer)accumulator.get("NFE", i), ((Number)accumulator.get(this.metric, i)).doubleValue()));
            }
        }
        Collections.sort(dataPoints);
        YIntervalSeries series = new YIntervalSeries((Comparable)key);
        DescriptiveStatistics statistics = new DescriptiveStatistics();
        int index = 0;
        int currentNFE = 500;
        while (index < dataPoints.size()) {
            DataPoint point = (DataPoint)dataPoints.get(index);
            if (point.getNFE() <= currentNFE) {
                statistics.addValue(point.getValue());
                ++index;
                continue;
            }
            if (statistics.getN() > 0L) {
                series.add((double)currentNFE, statistics.getPercentile(50.0), statistics.getPercentile(25.0), statistics.getPercentile(75.0));
            }
            statistics.clear();
            currentNFE += 500;
        }
        if (statistics.getN() > 0L) {
            if (series.isEmpty()) {
                series.add((double)(currentNFE - 500), statistics.getPercentile(50.0), statistics.getPercentile(25.0), statistics.getPercentile(75.0));
            }
            series.add((double)currentNFE, statistics.getPercentile(50.0), statistics.getPercentile(25.0), statistics.getPercentile(75.0));
        }
        dataset.addSeries(series);
    }

    @Override
    protected void update() {
        Paint paint;
        int i;
        XYLineAndShapeRenderer renderer;
        DefaultTableXYDataset dataset = null;
        if (this.controller.getShowIndividualTraces()) {
            dataset = new DefaultTableXYDataset();
            for (ResultKey key : this.frame.getSelectedResults()) {
                this.generateIndividualSeries(key, dataset);
            }
        } else {
            dataset = new YIntervalSeriesCollection();
            for (ResultKey key : this.frame.getSelectedResults()) {
                this.generateQuantileSeries(key, (YIntervalSeriesCollection)dataset);
            }
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.metric, (String)localization.getString("text.NFE"), (String)localization.getString("text.value"), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        if (this.controller.getShowIndividualTraces()) {
            renderer = new XYLineAndShapeRenderer(true, false);
            for (i = 0; i < dataset.getSeriesCount(); ++i) {
                paint = this.frame.getPaintHelper().get(dataset.getSeriesKey(i));
                renderer.setSeriesStroke(i, (Stroke)new BasicStroke(1.0f, 1, 1));
                renderer.setSeriesPaint(i, paint);
            }
            plot.setRenderer((XYItemRenderer)renderer);
        } else {
            renderer = new DeviationRenderer(true, false);
            for (i = 0; i < dataset.getSeriesCount(); ++i) {
                paint = this.frame.getPaintHelper().get(dataset.getSeriesKey(i));
                renderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f, 1, 1));
                renderer.setSeriesPaint(i, paint);
                renderer.setSeriesFillPaint(i, paint);
            }
            plot.setRenderer((XYItemRenderer)renderer);
        }
        final LegendItemCollection items = plot.getLegendItems();
        Iterator iterator = items.iterator();
        HashSet<ResultKey> uniqueKeys = new HashSet<ResultKey>();
        while (iterator.hasNext()) {
            LegendItem item = (LegendItem)iterator.next();
            if (uniqueKeys.contains(item.getSeriesKey())) {
                iterator.remove();
                continue;
            }
            uniqueKeys.add((ResultKey)item.getSeriesKey());
        }
        LegendItemSource source = new LegendItemSource(){

            public LegendItemCollection getLegendItems() {
                return items;
            }
        };
        LegendTitle legend = new LegendTitle(source);
        legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        legend.setFrame((BlockFrame)new LineBorder());
        legend.setBackgroundPaint((Paint)Color.WHITE);
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.addLegend(legend);
        NumberAxis domainAxis = new NumberAxis();
        domainAxis.setAutoRange(true);
        plot.setDomainAxis((ValueAxis)domainAxis);
        if (this.controller.getShowLastTrace() && !this.controller.getShowIndividualTraces() && this.controller.getLastAccumulator() != null && this.controller.getLastAccumulator().keySet().contains(this.metric)) {
            DefaultTableXYDataset dataset2 = new DefaultTableXYDataset();
            XYSeries series = new XYSeries((Comparable)((Object)localization.getString("text.last")), false, false);
            for (int i2 = 0; i2 < this.controller.getLastAccumulator().size(this.metric); ++i2) {
                series.add((Number)this.controller.getLastAccumulator().get("NFE", i2), (Number)this.controller.getLastAccumulator().get(this.metric, i2));
            }
            dataset2.addSeries(series);
            XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(true, false);
            renderer2.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f, 1, 1));
            renderer2.setSeriesPaint(0, (Paint)Color.BLACK);
            plot.setDataset(1, (XYDataset)dataset2);
            plot.setRenderer(1, (XYItemRenderer)renderer2);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        }
        this.removeAll();
        this.add((Component)new ChartPanel(chart), "Center");
        this.revalidate();
        this.repaint();
    }

    private static class DataPoint
    implements Comparable<DataPoint> {
        private final int NFE;
        private final double value;

        public DataPoint(int NFE, double value) {
            this.NFE = NFE;
            this.value = value;
        }

        @Override
        public int compareTo(DataPoint rhs) {
            return new CompareToBuilder().append(this.NFE, rhs.NFE).toComparison();
        }

        public int getNFE() {
            return this.NFE;
        }

        public double getValue() {
            return this.value;
        }
    }
}

