/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.diagnostics;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractListModel;

public class SortedListModel<T extends Comparable<T>>
extends AbstractListModel {
    private static final long serialVersionUID = 833503105693282917L;
    private final Set<T> set = new TreeSet<T>();

    public void remove(T item) {
        if (this.set.remove(item)) {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    public void clear() {
        this.set.clear();
        this.fireContentsChanged(this, 0, 0);
    }

    public void add(T item) {
        if (this.set.add(item)) {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    public void addAll(Collection<? extends T> collection) {
        if (this.set.addAll(collection)) {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    public int getIndexOf(T item) {
        Iterator<T> iterator = this.set.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            if (((Comparable)iterator.next()).equals(item)) {
                return index;
            }
            ++index;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int getSize() {
        return this.set.size();
    }

    @Override
    public T getElementAt(int index) {
        Iterator<T> iterator = this.set.iterator();
        while (index > 0) {
            iterator.next();
            --index;
        }
        return (T)((Comparable)iterator.next());
    }
}

