/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.diagnostics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.moeaframework.analysis.diagnostics.Controller;
import org.moeaframework.util.Localization;

public class StatisticalResultsViewer
extends JFrame {
    private static final long serialVersionUID = 25333840765750031L;
    private static Localization localization = Localization.getLocalization(StatisticalResultsViewer.class);
    private final Controller controller;
    private final String results;
    private Action saveAction;
    private Action exitAction;

    public StatisticalResultsViewer(Controller controller, String results) {
        super(localization.getString("title.statisticalResults"));
        this.controller = controller;
        this.results = results;
        this.initialize();
        this.layoutComponents();
        this.setSize(800, 600);
        this.setMinimumSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(2);
    }

    private void initialize() {
        this.saveAction = new AbstractAction(){
            private static final long serialVersionUID = -4467620869954438555L;
            {
                this.putValue("Name", localization.getString("action.saveStatistics.name"));
                this.putValue("ShortDescription", localization.getString("action.saveStatistics.description"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter("Text File (*.txt)", "txt"));
                int result = fileChooser.showSaveDialog(StatisticalResultsViewer.this);
                if (result == 0) {
                    File file = fileChooser.getSelectedFile();
                    PrintWriter writer = null;
                    if (!file.getName().toLowerCase().endsWith(".txt")) {
                        file = new File(file.getParent(), file.getName() + ".txt");
                    }
                    try {
                        writer = new PrintWriter(new FileWriter(file));
                        writer.print(StatisticalResultsViewer.this.results);
                    }
                    catch (IOException e) {
                        StatisticalResultsViewer.this.controller.handleException(e);
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
            }
        };
        this.exitAction = new AbstractAction(){
            private static final long serialVersionUID = -4467620869954438555L;
            {
                this.putValue("Name", localization.getString("action.exit.name"));
                this.putValue("ShortDescription", localization.getString("action.exit.description"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                StatisticalResultsViewer.this.dispose();
            }
        };
    }

    private void layoutComponents() {
        JMenu file = new JMenu(localization.getString("menu.file"));
        file.add(new JMenuItem(this.saveAction));
        file.addSeparator();
        file.add(new JMenuItem(this.exitAction));
        JMenuBar menu = new JMenuBar();
        menu.add(file);
        this.setJMenuBar(menu);
        JTextArea textArea = new JTextArea(this.results);
        textArea.setWrapStyleWord(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(textArea), "Center");
    }
}

