/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.plot;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.moeaframework.Analyzer;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.diagnostics.PaintHelper;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Population;
import org.moeaframework.core.Solution;

public class Plot {
    private JFreeChart chart;
    private PaintHelper paintHelper = new PaintHelper();
    private int currentDataset = -1;

    private void createXYPlot() {
        if (this.chart == null) {
            NumberAxis xAxis = new NumberAxis("");
            xAxis.setAutoRangeIncludesZero(false);
            NumberAxis yAxis = new NumberAxis("");
            yAxis.setAutoRangeIncludesZero(false);
            XYPlot plot = new XYPlot();
            plot.setDomainAxis((ValueAxis)xAxis);
            plot.setRangeAxis((ValueAxis)yAxis);
            StandardXYToolTipGenerator toolTipGenerator = new StandardXYToolTipGenerator();
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
            plot.setRenderer((XYItemRenderer)renderer);
            plot.setOrientation(PlotOrientation.VERTICAL);
            this.chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (org.jfree.chart.plot.Plot)plot, true);
            ChartFactory.getChartTheme().apply(this.chart);
        } else if (!(this.chart.getPlot() instanceof XYPlot)) {
            throw new FrameworkException("Can not combine XY plot and categorial plot");
        }
    }

    private void createCategoryPlot() {
        if (this.chart == null) {
            CategoryAxis xAxis = new CategoryAxis("");
            NumberAxis yAxis = new NumberAxis("Value");
            yAxis.setAutoRangeIncludesZero(false);
            BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
            renderer.setFillBox(true);
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new BoxAndWhiskerToolTipGenerator());
            CategoryPlot plot = new CategoryPlot();
            plot.setDomainAxis(xAxis);
            plot.setRangeAxis((ValueAxis)yAxis);
            plot.setRenderer((CategoryItemRenderer)renderer);
            this.chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (org.jfree.chart.plot.Plot)plot, true);
            ChartFactory.getChartTheme().apply(this.chart);
        } else if (!(this.chart.getPlot() instanceof CategoryPlot)) {
            throw new FrameworkException("Can not combine XY plot and categorial plot");
        }
    }

    public Plot setTitle(String title) {
        this.chart.setTitle(title);
        return this;
    }

    public Plot setXLabel(String label) {
        if (this.chart.getPlot() instanceof XYPlot) {
            this.chart.getXYPlot().getDomainAxis().setLabel(label);
        } else if (this.chart.getPlot() instanceof CategoryPlot) {
            this.chart.getCategoryPlot().getDomainAxis().setLabel(label);
        }
        return this;
    }

    public Plot setYLabel(String label) {
        if (this.chart.getPlot() instanceof XYPlot) {
            this.chart.getXYPlot().getRangeAxis().setLabel(label);
        } else if (this.chart.getPlot() instanceof CategoryPlot) {
            this.chart.getCategoryPlot().getRangeAxis().setLabel(label);
        }
        return this;
    }

    private Plot setLabelsIfBlank(String xlabel, String ylabel) {
        if (this.chart.getPlot() instanceof XYPlot) {
            XYPlot plot = this.chart.getXYPlot();
            if (plot.getDomainAxis().getLabel().isEmpty()) {
                plot.getDomainAxis().setLabel(xlabel);
            }
            if (plot.getRangeAxis().getLabel().isEmpty()) {
                plot.getRangeAxis().setLabel(ylabel);
            }
        } else if (this.chart.getPlot() instanceof CategoryPlot) {
            CategoryPlot plot = this.chart.getCategoryPlot();
            if (plot.getDomainAxis().getLabel().isEmpty()) {
                plot.getDomainAxis().setLabel(xlabel);
            }
            if (plot.getRangeAxis().getLabel().isEmpty()) {
                plot.getRangeAxis().setLabel(ylabel);
            }
        }
        return this;
    }

    public Plot setBackgroundPaint(Paint paint) {
        if (this.chart.getPlot() instanceof XYPlot) {
            this.chart.getXYPlot().setBackgroundPaint(paint);
        } else if (this.chart.getPlot() instanceof CategoryPlot) {
            this.chart.getCategoryPlot().setBackgroundPaint(paint);
        }
        return this;
    }

    public Plot setGridPaint(Paint paint) {
        if (this.chart.getPlot() instanceof XYPlot) {
            this.chart.getXYPlot().setRangeGridlinePaint(paint);
            this.chart.getXYPlot().setDomainGridlinePaint(paint);
        } else if (this.chart.getPlot() instanceof CategoryPlot) {
            this.chart.getCategoryPlot().setRangeGridlinePaint(paint);
            this.chart.getCategoryPlot().setDomainGridlinePaint(paint);
        }
        return this;
    }

    public Plot setXLim(double min, double max) {
        if (this.chart.getPlot() instanceof XYPlot) {
            this.chart.getXYPlot().getDomainAxis().setRange(min, max);
        }
        return this;
    }

    public Plot setYLim(double min, double max) {
        if (this.chart.getPlot() instanceof XYPlot) {
            this.chart.getXYPlot().getRangeAxis().setRange(min, max);
        } else if (this.chart.getPlot() instanceof CategoryPlot) {
            this.chart.getCategoryPlot().getRangeAxis().setRange(min, max);
        }
        return this;
    }

    public Plot scatter(String label, double[] x, double[] y) {
        return this.scatter(label, this.toList(x), this.toList(y));
    }

    public Plot scatter(String label, List<? extends Number> x, List<? extends Number> y) {
        return this.scatter(label, x, y, null);
    }

    private Plot scatter(String label, List<? extends Number> x, List<? extends Number> y, XYSeriesCollection dataset) {
        if (dataset == null) {
            this.createXYPlot();
            ++this.currentDataset;
            dataset = new XYSeriesCollection();
        }
        XYSeries series = new XYSeries((Comparable)((Object)label), false, true);
        for (int i = 0; i < x.size(); ++i) {
            series.add(x.get(i), y.get(i));
        }
        dataset.addSeries(series);
        XYPlot plot = this.chart.getXYPlot();
        plot.setDataset(this.currentDataset, (XYDataset)dataset);
        Paint paint = this.paintHelper.get(dataset.getSeriesKey(0));
        XYDotRenderer renderer = new XYDotRenderer();
        renderer.setDotHeight(6);
        renderer.setDotWidth(6);
        renderer.setBasePaint(paint);
        renderer.setBaseFillPaint(paint);
        plot.setRenderer(this.currentDataset, (XYItemRenderer)renderer);
        return this;
    }

    private List<Double> toList(double[] x) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < x.length; ++i) {
            result.add(x[i]);
        }
        return result;
    }

    public Plot add(String label, Population population) {
        Solution solution = population.get(0);
        if (solution.getNumberOfObjectives() == 1) {
            return this.add(label, population, 0, 0);
        }
        return this.add(label, population, 0, 1);
    }

    public Plot add(String label, Population population, int x, int y) {
        ArrayList<Double> xs = new ArrayList<Double>();
        ArrayList<Double> ys = new ArrayList<Double>();
        for (Solution solution : population) {
            if (solution.violatesConstraints()) continue;
            xs.add(solution.getObjective(x));
            ys.add(solution.getObjective(y));
        }
        this.scatter(label, xs, ys);
        this.setLabelsIfBlank("Objective " + (x + 1), "Objective " + (y + 1));
        return this;
    }

    public Plot add(Accumulator accumulator) {
        this.createXYPlot();
        ++this.currentDataset;
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (String key : accumulator.keySet()) {
            if (key.equals("NFE")) continue;
            this.add(key, accumulator, key, dataset);
        }
        return this;
    }

    public Plot add(String label, Accumulator accumulator, String metric) {
        return this.add(label, accumulator, metric, null);
    }

    private Plot add(String label, Accumulator accumulator, String metric, XYSeriesCollection dataset) {
        ArrayList<Number> xs = new ArrayList<Number>();
        ArrayList<Number> ys = new ArrayList<Number>();
        try {
            for (int i = 0; i < accumulator.size("NFE"); ++i) {
                xs.add((Number)accumulator.get("NFE", i));
                ys.add((Number)accumulator.get(metric, i));
            }
        }
        catch (ClassCastException e) {
            return this;
        }
        this.line(label, xs, ys, dataset);
        this.setLabelsIfBlank("NFE", "Value");
        return this;
    }

    public Plot line(String label, double[] x, double[] y) {
        return this.line(label, this.toList(x), this.toList(y));
    }

    public Plot line(String label, List<? extends Number> x, List<? extends Number> y) {
        return this.line(label, x, y, null);
    }

    private Plot line(String label, List<? extends Number> x, List<? extends Number> y, XYSeriesCollection dataset) {
        if (dataset == null) {
            this.createXYPlot();
            ++this.currentDataset;
            dataset = new XYSeriesCollection();
        }
        XYSeries series = new XYSeries((Comparable)((Object)label), false, true);
        for (int i = 0; i < x.size(); ++i) {
            series.add(x.get(i), y.get(i));
        }
        dataset.addSeries(series);
        XYPlot plot = this.chart.getXYPlot();
        plot.setDataset(this.currentDataset, (XYDataset)dataset);
        Paint paint = this.paintHelper.get(dataset.getSeriesKey(0));
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setAutoPopulateSeriesStroke(false);
        renderer.setBaseStroke((Stroke)new BasicStroke(3.0f, 1, 1));
        renderer.setBasePaint(paint);
        renderer.setBaseFillPaint(paint);
        plot.setRenderer(this.currentDataset, (XYItemRenderer)renderer);
        return this;
    }

    public Plot area(String label, double[] x, double[] y) {
        return this.area(label, this.toList(x), this.toList(y));
    }

    public Plot area(String label, List<? extends Number> x, List<? extends Number> y) {
        return this.area(label, x, y, null);
    }

    private Plot area(String label, List<? extends Number> x, List<? extends Number> y, XYSeriesCollection dataset) {
        if (dataset == null) {
            this.createXYPlot();
            ++this.currentDataset;
            dataset = new XYSeriesCollection();
        }
        XYSeries series = new XYSeries((Comparable)((Object)label), false, true);
        for (int i = 0; i < x.size(); ++i) {
            series.add(x.get(i), y.get(i));
        }
        dataset.addSeries(series);
        XYPlot plot = this.chart.getXYPlot();
        plot.setDataset(this.currentDataset, (XYDataset)dataset);
        Paint paint = this.paintHelper.get(dataset.getSeriesKey(0));
        XYAreaRenderer renderer = new XYAreaRenderer();
        renderer.setAutoPopulateSeriesStroke(false);
        renderer.setBaseStroke((Stroke)new BasicStroke(3.0f, 1, 1));
        renderer.setBasePaint(paint);
        renderer.setBaseFillPaint(paint);
        plot.setRenderer(this.currentDataset, (XYItemRenderer)renderer);
        return this;
    }

    public Plot stacked(String label, double[] x, double[] y) {
        return this.stacked(label, this.toList(x), this.toList(y));
    }

    public Plot stacked(String label, List<? extends Number> x, List<? extends Number> y) {
        return this.stacked(label, x, y, null);
    }

    private Plot stacked(String label, List<? extends Number> x, List<? extends Number> y, DefaultTableXYDataset dataset) {
        if (dataset == null) {
            this.createXYPlot();
            XYPlot plot = this.chart.getXYPlot();
            if (plot.getDataset(this.currentDataset) instanceof DefaultTableXYDataset) {
                dataset = (DefaultTableXYDataset)plot.getDataset(this.currentDataset);
            } else {
                ++this.currentDataset;
                dataset = new DefaultTableXYDataset();
            }
        }
        XYSeries series = new XYSeries((Comparable)((Object)label), true, false);
        for (int i = 0; i < x.size(); ++i) {
            series.add(x.get(i), y.get(i));
        }
        dataset.addSeries(series);
        XYPlot plot = this.chart.getXYPlot();
        plot.setDataset(this.currentDataset, (XYDataset)dataset);
        Paint paint = this.paintHelper.get(dataset.getSeriesKey(0));
        StackedXYAreaRenderer renderer = new StackedXYAreaRenderer();
        renderer.setAutoPopulateSeriesStroke(false);
        renderer.setBaseStroke((Stroke)new BasicStroke(3.0f, 1, 1));
        renderer.setBasePaint(paint);
        renderer.setBaseFillPaint(paint);
        plot.setRenderer(this.currentDataset, (XYItemRenderer)renderer);
        return this;
    }

    public Plot add(Analyzer analyzer) {
        return this.add(analyzer.getAnalysis());
    }

    public Plot add(Analyzer.AnalyzerResults result) {
        this.createCategoryPlot();
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        for (String algorithm : result.getAlgorithms()) {
            for (String indicator : result.get(algorithm).getIndicators()) {
                ArrayList<Double> values = new ArrayList<Double>();
                for (double value : result.get(algorithm).get(indicator).getValues()) {
                    values.add(value);
                }
                dataset.add(values, (Comparable)((Object)algorithm), (Comparable)((Object)indicator));
            }
        }
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.setDataset((CategoryDataset)dataset);
        return this;
    }

    public Plot withSize(float size) {
        if (this.chart.getPlot() instanceof XYPlot) {
            XYPlot plot = this.chart.getXYPlot();
            XYItemRenderer renderer = plot.getRenderer(this.currentDataset);
            if (renderer instanceof XYDotRenderer) {
                ((XYDotRenderer)renderer).setDotWidth((int)(size * 2.0f));
                ((XYDotRenderer)renderer).setDotHeight((int)(size * 2.0f));
            } else if (renderer.getBaseStroke() instanceof BasicStroke) {
                BasicStroke oldStroke = (BasicStroke)renderer.getBaseStroke();
                BasicStroke newStroke = new BasicStroke(size, oldStroke.getEndCap(), oldStroke.getLineJoin(), oldStroke.getMiterLimit(), oldStroke.getDashArray(), oldStroke.getDashPhase());
                renderer.setBaseStroke((Stroke)newStroke);
            } else {
                renderer.setBaseStroke((Stroke)new BasicStroke(size, 1, 1));
            }
        }
        return this;
    }

    public Plot withPaint(Paint ... paint) {
        block3: {
            block2: {
                if (!(this.chart.getPlot() instanceof XYPlot)) break block2;
                XYPlot plot = this.chart.getXYPlot();
                XYDataset dataset = plot.getDataset(this.currentDataset);
                XYItemRenderer renderer = plot.getRenderer(this.currentDataset);
                for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                    Paint p = paint[i % paint.length];
                    this.paintHelper.set(dataset.getSeriesKey(i), p);
                    renderer.setSeriesPaint(i, p);
                    if (!(renderer instanceof XYLineAndShapeRenderer)) continue;
                    ((XYLineAndShapeRenderer)renderer).setSeriesFillPaint(i, p);
                }
                break block3;
            }
            if (!(this.chart.getPlot() instanceof CategoryPlot)) break block3;
            CategoryPlot plot = this.chart.getCategoryPlot();
            CategoryDataset dataset = plot.getDataset();
            CategoryItemRenderer renderer = plot.getRenderer();
            for (int i = 0; i < dataset.getRowCount(); ++i) {
                Paint p = paint[i % paint.length];
                this.paintHelper.set(dataset.getRowKey(i), p);
                renderer.setSeriesPaint(i, p);
            }
        }
        return this;
    }

    public Plot save(String filename) throws IOException {
        return this.save(new File(filename));
    }

    public Plot save(File file) throws IOException {
        String filename = file.getName();
        String extension = filename.substring(filename.lastIndexOf(46) + 1, filename.length());
        return this.save(file, extension, 800, 600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot save(File file, String format, int width, int height) throws IOException {
        if (format.equalsIgnoreCase("PNG")) {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)width, (int)height);
        } else if (format.equalsIgnoreCase("JPG") || format.equalsIgnoreCase("JPEG")) {
            ChartUtilities.saveChartAsJPEG((File)file, (JFreeChart)this.chart, (int)width, (int)height);
        } else if (format.equalsIgnoreCase("SVG")) {
            String svg = this.generateSVG(width, height);
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(file));
                writer.write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
                writer.write(svg);
                writer.write("\n");
                writer.flush();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        return this;
    }

    private String generateSVG(int width, int height) {
        Graphics2D g2 = this.createSVGGraphics2D(width, height);
        if (g2 == null) {
            throw new IllegalStateException("JFreeSVG library is not present.");
        }
        g2.setRenderingHint(new RenderingHints.Key(0){

            @Override
            public boolean isCompatibleValue(Object val) {
                return val instanceof Boolean;
            }
        }, true);
        String svg = null;
        Rectangle2D.Double drawArea = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.chart.draw(g2, (Rectangle2D)drawArea);
        try {
            Method m = g2.getClass().getMethod("getSVGElement", new Class[0]);
            svg = (String)m.invoke((Object)g2, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return svg;
    }

    private Graphics2D createSVGGraphics2D(int w, int h) {
        try {
            Class<?> svgGraphics2d = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            Constructor<?> ctor = svgGraphics2d.getConstructor(Integer.TYPE, Integer.TYPE);
            return (Graphics2D)ctor.newInstance(w, h);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (InstantiationException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            return null;
        }
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public ChartPanel getChartPanel() {
        return new ChartPanel(this.chart);
    }

    public JFrame show() {
        return this.show(800, 600);
    }

    public JFrame show(int width, int height) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)this.getChartPanel(), "Center");
        frame.setPreferredSize(new Dimension(width, height));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setTitle("MOEA Framework Plot");
        frame.setVisible(true);
        return frame;
    }

    public JDialog showDialog() {
        return this.showDialog(800, 600);
    }

    public JDialog showDialog(int width, int height) {
        JDialog frame = new JDialog();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)this.getChartPanel(), "Center");
        frame.setPreferredSize(new Dimension(width, height));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setTitle("MOEA Framework Plot");
        frame.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        frame.setVisible(true);
        return frame;
    }
}

