/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.FractalDimension;
import org.moeaframework.analysis.sensitivity.MetricFileReader;
import org.moeaframework.analysis.sensitivity.Parameter;
import org.moeaframework.analysis.sensitivity.ParameterFile;
import org.moeaframework.analysis.sensitivity.SampleReader;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.util.CommandLineUtility;

public class Analysis
extends CommandLineUtility {
    private ParameterFile parameterFile;
    private double[][] metrics;
    private double[][] parameters;
    private int metric;
    private double threshold = 0.75;
    private int bandWidth = 10000;

    private double[] toArray(Properties properties) {
        double[] result = new double[this.parameterFile.size()];
        for (int i = 0; i < this.parameterFile.size(); ++i) {
            result[i] = Double.parseDouble(properties.getProperty(this.parameterFile.get(i).getName()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[][] loadMetrics(File file) throws IOException {
        MetricFileReader reader = null;
        ArrayList<double[]> metricList = new ArrayList<double[]>();
        try {
            reader = new MetricFileReader(file);
            while (reader.hasNext()) {
                double[] metrics = reader.next();
                for (int i = 0; i < metrics.length; ++i) {
                    if (i != 1 && i != 2 && i != 4 && i != 5 && i != 6) continue;
                    metrics[i] = Math.max(0.0, 1.0 - metrics[i]);
                }
                metricList.add(metrics);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return (double[][])metricList.toArray((T[])new double[0][]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[][] loadParameters(File file) throws IOException {
        SampleReader reader = null;
        ArrayList<double[]> parameterList = new ArrayList<double[]>();
        try {
            reader = new SampleReader(file, this.parameterFile);
            while (reader.hasNext()) {
                parameterList.add(this.toArray(reader.next()));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return (double[][])parameterList.toArray((T[])new double[0][]);
    }

    private double[][] normalize(double[][] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            for (int j = 0; j < parameters[i].length; ++j) {
                Parameter parameter = this.parameterFile.get(j);
                parameters[i][j] = (parameters[i][j] - parameter.getLowerBound()) / (parameter.getUpperBound() - parameter.getLowerBound());
            }
        }
        return parameters;
    }

    private double[][] threshold(int metric, double threshold) {
        int count = 0;
        for (int i = 0; i < this.metrics.length; ++i) {
            if (!(this.metrics[i][metric] >= threshold)) continue;
            ++count;
        }
        double[][] result = new double[count][];
        count = 0;
        for (int i = 0; i < this.metrics.length; ++i) {
            if (!(this.metrics[i][metric] >= threshold)) continue;
            result[count] = this.parameters[i];
            ++count;
        }
        return result;
    }

    private double calculateBest() {
        double best = 0.0;
        for (int i = 0; i < this.metrics.length; ++i) {
            best = Math.max(this.metrics[i][this.metric], best);
        }
        return best;
    }

    private double calculateAttainment() {
        int count = 0;
        for (int i = 0; i < this.metrics.length; ++i) {
            if (!(this.metrics[i][this.metric] >= this.threshold)) continue;
            ++count;
        }
        return (double)count / (double)this.metrics.length;
    }

    private double calculateControllability() {
        double[][] attainmentVolume = this.threshold(this.metric, this.threshold);
        return FractalDimension.computeDimension(this.normalize(attainmentVolume)) / FractalDimension.computeDimension(this.parameters);
    }

    private double calculateEfficiency() {
        int max = -1;
        int evalIndex = -1;
        for (int i = 0; i < this.parameterFile.size(); ++i) {
            Parameter parameter = this.parameterFile.get(i);
            if (!parameter.getName().equals("maxEvaluations")) continue;
            max = (int)parameter.getUpperBound();
            evalIndex = i;
            break;
        }
        if (evalIndex == -1) {
            throw new FrameworkException("no maxEvaluations parameter");
        }
        int band = max;
        block1: for (int i = 0; i <= max - this.bandWidth; i += this.bandWidth) {
            int count = 0;
            int total = 0;
            for (int j = 0; j < this.metrics.length; ++j) {
                if (!(this.parameters[j][evalIndex] >= (double)i) || !(this.parameters[j][evalIndex] <= (double)(i + this.bandWidth - 1))) continue;
                ++total;
                if (!(this.metrics[j][this.metric] > this.threshold) || !((double)(++count) / (double)total >= 0.9)) continue;
                band = i;
                continue block1;
            }
        }
        return (double)(max - band) / (double)max;
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"parameterFile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"parameters");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"metric");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withLongOpt((String)"hypervolume");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"efficiency");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"band");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"width");
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"controllability");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"threshold");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"percent");
        options.addOption(OptionBuilder.create((char)'t'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        PrintStream output = null;
        this.parameterFile = new ParameterFile(new File(commandLine.getOptionValue("parameterFile")));
        this.parameters = this.loadParameters(new File(commandLine.getOptionValue("parameters")));
        this.metric = Integer.parseInt(commandLine.getOptionValue("metric"));
        if (commandLine.hasOption("band")) {
            this.bandWidth = Integer.parseInt(commandLine.getOptionValue("band"));
        }
        if (commandLine.hasOption("threshold")) {
            this.threshold = Double.parseDouble(commandLine.getOptionValue("threshold"));
        }
        if (this.metric == 0) {
            if (commandLine.hasOption("hypervolume")) {
                this.threshold *= Double.parseDouble(commandLine.getOptionValue("hypervolume"));
            } else {
                throw new MissingOptionException("requires hypervolume option");
            }
        }
        try {
            output = commandLine.hasOption("output") ? new PrintStream(new File(commandLine.getOptionValue("output"))) : System.out;
            String[] filenames = commandLine.getArgs();
            for (int i = 0; i < filenames.length; ++i) {
                if (i > 0) {
                    output.println();
                }
                this.metrics = this.loadMetrics(new File(filenames[i]));
                output.print(filenames[i]);
                output.println(":");
                output.print("  Best: ");
                output.println(this.calculateBest());
                output.print("  Attainment: ");
                output.println(this.calculateAttainment());
                if (commandLine.hasOption("controllability")) {
                    output.print("  Controllability: ");
                    output.println(this.calculateControllability());
                }
                if (!commandLine.hasOption("efficiency")) continue;
                output.print("  Efficiency: ");
                output.println(this.calculateEfficiency());
            }
        }
        finally {
            if (output != null && output != System.out) {
                output.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new Analysis().start(args);
    }
}

