/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.moeaframework.Executor;
import org.moeaframework.Instrumenter;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.sensitivity.OutputWriter;
import org.moeaframework.analysis.sensitivity.ParameterFile;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileWriter;
import org.moeaframework.analysis.sensitivity.SampleReader;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.util.CommandLineUtility;

public class DetailedEvaluator
extends CommandLineUtility {
    protected Problem problem;
    protected OutputWriter output;
    protected SampleReader input;

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"parameterFile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"algorithm");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withLongOpt((String)"frequency");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"nfe");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"properties");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"p1=v1;p2=v2;...");
        OptionBuilder.withValueSeparator((char)';');
        options.addOption(OptionBuilder.create((char)'x'));
        OptionBuilder.withLongOpt((String)"seed");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"novariables");
        options.addOption(OptionBuilder.create((char)'n'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws IOException {
        String outputFilePattern = commandLine.getOptionValue("output");
        ParameterFile parameterFile = new ParameterFile(new File(commandLine.getOptionValue("parameterFile")));
        File inputFile = new File(commandLine.getOptionValue("input"));
        int frequency = 1000;
        if (commandLine.hasOption("frequency")) {
            frequency = Integer.parseInt(commandLine.getOptionValue("frequency"));
        }
        try {
            this.problem = ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem"));
            try {
                this.input = new SampleReader(new FileReader(inputFile), parameterFile);
                int count = 1;
                while (this.input.hasNext()) {
                    try {
                        String outputFileName = String.format(outputFilePattern, count);
                        System.out.print("Processing " + outputFileName + "...");
                        File outputFile = new File(outputFileName);
                        if (outputFile.exists()) {
                            outputFile.delete();
                        }
                        this.output = new ResultFileWriter(this.problem, outputFile, !commandLine.hasOption("novariables"));
                        Properties defaultProperties = new Properties();
                        if (commandLine.hasOption("properties")) {
                            for (String property : commandLine.getOptionValues("properties")) {
                                String[] tokens = property.split("=");
                                if (tokens.length != 2) {
                                    throw new FrameworkException("malformed property argument");
                                }
                                defaultProperties.setProperty(tokens[0], tokens[1]);
                            }
                        }
                        if (commandLine.hasOption("epsilon")) {
                            defaultProperties.setProperty("epsilon", commandLine.getOptionValue("epsilon"));
                        }
                        if (commandLine.hasOption("seed")) {
                            PRNG.setSeed(Long.parseLong(commandLine.getOptionValue("seed")));
                        }
                        Properties properties = this.input.next();
                        properties.putAll((Map<?, ?>)defaultProperties);
                        this.process(commandLine.getOptionValue("algorithm"), properties, frequency);
                        System.out.println("done.");
                    }
                    finally {
                        if (this.output != null) {
                            this.output.close();
                        }
                    }
                    ++count;
                }
            }
            finally {
                if (this.input != null) {
                    this.input.close();
                }
            }
        }
        finally {
            if (this.problem != null) {
                this.problem.close();
            }
        }
        System.out.println("Finished!");
    }

    protected void process(String algorithmName, Properties properties, int frequency) throws IOException {
        if (!properties.containsKey("maxEvaluations")) {
            throw new FrameworkException("maxEvaluations not defined");
        }
        int maxEvaluations = (int)Double.parseDouble(properties.getProperty("maxEvaluations"));
        Instrumenter instrumenter = new Instrumenter().withProblem(this.problem).withFrequency(frequency).attachApproximationSetCollector().attachElapsedTimeCollector();
        new Executor().withSameProblemAs(instrumenter).withAlgorithm(algorithmName).withMaxEvaluations(maxEvaluations).withInstrumenter(instrumenter).withProperties(properties).run();
        Accumulator accumulator = instrumenter.getLastAccumulator();
        for (int i = 0; i < accumulator.size("NFE"); ++i) {
            Properties metadata = new Properties();
            metadata.setProperty("NFE", accumulator.get("NFE", i).toString());
            metadata.setProperty("ElapsedTime", accumulator.get("Elapsed Time", i).toString());
            Iterable solutions = (Iterable)((Object)accumulator.get("Approximation Set", i));
            NondominatedPopulation result = new NondominatedPopulation(solutions);
            this.output.append(new ResultEntry(result, metadata));
        }
    }

    public static void main(String[] args) throws Exception {
        new DetailedEvaluator().start(args);
    }
}

