/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.EpsilonBoxDominanceComparator;

public class EpsilonHelper {
    private EpsilonHelper() {
    }

    public static double getEpsilon(Problem problem) {
        String name = problem.getName();
        int numberOfObjectives = problem.getNumberOfObjectives();
        if (name.startsWith("DTLZ")) {
            return numberOfObjectives == 2 ? 0.01 : (numberOfObjectives == 3 ? 0.05 : 0.1 + 0.05 * (double)(numberOfObjectives - 3));
        }
        if (name.startsWith("UF")) {
            if (name.equals("UF1")) {
                return 0.001;
            }
            if (name.equals("UF3")) {
                return 8.0E-4;
            }
            if (name.equals("UF5")) {
                return 1.0E-6;
            }
            if (name.equals("UF6")) {
                return 1.0E-6;
            }
            if (name.equals("UF8")) {
                return 0.0045;
            }
            if (name.equals("UF9")) {
                return 0.008;
            }
            if (name.equals("UF10")) {
                return 0.001;
            }
            if (numberOfObjectives == 2) {
                return 0.005;
            }
            if (numberOfObjectives == 3) {
                return 0.07;
            }
            if (numberOfObjectives == 5) {
                return 0.2;
            }
            throw new IllegalArgumentException("number of objectives not supported");
        }
        if (name.equalsIgnoreCase("Belegundu")) {
            return 0.1;
        }
        if (name.equalsIgnoreCase("Binh")) {
            return 0.25;
        }
        if (name.equalsIgnoreCase("Binh2")) {
            return 0.35;
        }
        if (name.equalsIgnoreCase("Binh3")) {
            return 0.01;
        }
        if (name.equalsIgnoreCase("Binh4")) {
            return 0.01;
        }
        if (name.equalsIgnoreCase("Fonseca")) {
            return 0.0025;
        }
        if (name.equalsIgnoreCase("Fonseca2")) {
            return 0.007;
        }
        if (name.equalsIgnoreCase("Jimenez")) {
            return 0.05;
        }
        if (name.equalsIgnoreCase("Kita")) {
            return 0.01;
        }
        if (name.equalsIgnoreCase("Kursawe")) {
            return 0.035;
        }
        if (name.equalsIgnoreCase("Laumanns")) {
            return 0.02;
        }
        if (name.equalsIgnoreCase("Lis")) {
            return 0.004;
        }
        if (name.equalsIgnoreCase("Murata")) {
            return 0.02;
        }
        if (name.equalsIgnoreCase("Obayashi")) {
            return 0.006;
        }
        if (name.equalsIgnoreCase("OKA1")) {
            return 0.0145;
        }
        if (name.equalsIgnoreCase("OKA2")) {
            return 1.0E-6;
        }
        if (name.equalsIgnoreCase("Osyczka")) {
            return 0.0012;
        }
        if (name.equalsIgnoreCase("Osyczka2")) {
            return 0.5;
        }
        if (name.equalsIgnoreCase("Poloni")) {
            return 0.04;
        }
        if (name.equalsIgnoreCase("Quagliarella")) {
            return 0.03;
        }
        if (name.equalsIgnoreCase("Rendon")) {
            return 0.01;
        }
        if (name.equalsIgnoreCase("Rendon2")) {
            return 0.027;
        }
        if (name.equalsIgnoreCase("Schaffer")) {
            return 0.02;
        }
        if (name.equalsIgnoreCase("Schaffer2")) {
            return 0.017;
        }
        if (name.equalsIgnoreCase("Srinivas")) {
            return 1.5;
        }
        if (name.equalsIgnoreCase("Tamaki")) {
            return 0.06;
        }
        if (name.equalsIgnoreCase("Tanaka")) {
            return 0.0045;
        }
        if (name.equalsIgnoreCase("Viennet")) {
            return 0.1;
        }
        if (name.equalsIgnoreCase("Viennet2")) {
            return 0.0062;
        }
        if (name.equalsIgnoreCase("Viennet3")) {
            return 0.011;
        }
        if (name.equalsIgnoreCase("Viennet4")) {
            return 0.085;
        }
        return 0.01;
    }

    public static EpsilonBoxDominanceArchive convert(Population population, double[] epsilon) {
        boolean isSameEpsilon = false;
        if (population instanceof EpsilonBoxDominanceArchive) {
            EpsilonBoxDominanceArchive result = (EpsilonBoxDominanceArchive)population;
            EpsilonBoxDominanceComparator comparator = result.getComparator();
            isSameEpsilon = true;
            for (int i = 0; i < epsilon.length; ++i) {
                if (epsilon[i] == comparator.getEpsilon(i)) continue;
                isSameEpsilon = false;
                break;
            }
        }
        if (isSameEpsilon) {
            return (EpsilonBoxDominanceArchive)population;
        }
        return new EpsilonBoxDominanceArchive(epsilon, (Iterable<? extends Solution>)population);
    }
}

