/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.EpsilonHelper;
import org.moeaframework.analysis.sensitivity.MetricFileWriter;
import org.moeaframework.analysis.sensitivity.OutputWriter;
import org.moeaframework.analysis.sensitivity.ParameterFile;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileWriter;
import org.moeaframework.analysis.sensitivity.SampleReader;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Problem;
import org.moeaframework.core.indicator.QualityIndicator;
import org.moeaframework.core.spi.AlgorithmFactory;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.problem.TimingProblem;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;

public class Evaluator
extends CommandLineUtility {
    protected Problem problem;
    protected OutputWriter output;
    protected SampleReader input;

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"parameterFile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"algorithm");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withLongOpt((String)"properties");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"p1=v1;p2=v2;...");
        OptionBuilder.withValueSeparator((char)';');
        options.addOption(OptionBuilder.create((char)'x'));
        OptionBuilder.withLongOpt((String)"seed");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"metrics");
        options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withLongOpt((String)"reference");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"novariables");
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withLongOpt((String)"force");
        options.addOption(OptionBuilder.create((char)'f'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws IOException {
        File outputFile = new File(commandLine.getOptionValue("output"));
        File inputFile = new File(commandLine.getOptionValue("input"));
        ParameterFile parameterFile = new ParameterFile(new File(commandLine.getOptionValue("parameterFile")));
        if (!commandLine.hasOption("force") && outputFile.lastModified() > 0L && inputFile.lastModified() > outputFile.lastModified()) {
            throw new FrameworkException("input appears to be newer than output");
        }
        try {
            this.problem = ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem"));
            try {
                this.input = new SampleReader(new FileReader(inputFile), parameterFile);
                try {
                    if (commandLine.hasOption("metrics")) {
                        NondominatedPopulation referenceSet = null;
                        referenceSet = commandLine.hasOption("reference") ? new NondominatedPopulation(PopulationIO.readObjectives(new File(commandLine.getOptionValue("reference")))) : ProblemFactory.getInstance().getReferenceSet(commandLine.getOptionValue("problem"));
                        if (referenceSet == null) {
                            throw new FrameworkException("no reference set available");
                        }
                        QualityIndicator indicator = new QualityIndicator(this.problem, referenceSet);
                        this.output = new MetricFileWriter(indicator, outputFile);
                    } else {
                        this.output = new ResultFileWriter(this.problem, outputFile, !commandLine.hasOption("novariables"));
                    }
                    for (int i = 0; i < this.output.getNumberOfEntries(); ++i) {
                        if (!this.input.hasNext()) {
                            throw new FrameworkException("output has more entries than input");
                        }
                        this.input.next();
                    }
                    Properties defaultProperties = new Properties();
                    if (commandLine.hasOption("properties")) {
                        for (String property : commandLine.getOptionValues("properties")) {
                            String[] tokens = property.split("=");
                            if (tokens.length != 2) {
                                throw new FrameworkException("malformed property argument");
                            }
                            defaultProperties.setProperty(tokens[0], tokens[1]);
                        }
                    }
                    if (commandLine.hasOption("epsilon")) {
                        defaultProperties.setProperty("epsilon", commandLine.getOptionValue("epsilon"));
                    }
                    if (commandLine.hasOption("seed")) {
                        PRNG.setSeed(Long.parseLong(commandLine.getOptionValue("seed")));
                    }
                    while (this.input.hasNext()) {
                        Properties properties = this.input.next();
                        properties.putAll((Map<?, ?>)defaultProperties);
                        this.process(commandLine.getOptionValue("algorithm"), properties);
                    }
                }
                finally {
                    if (this.output != null) {
                        this.output.close();
                    }
                }
            }
            finally {
                if (this.input != null) {
                    this.input.close();
                }
            }
        }
        finally {
            if (this.problem != null) {
                this.problem.close();
            }
        }
    }

    protected void process(String algorithmName, Properties properties) throws IOException {
        TimingProblem timingProblem = new TimingProblem(this.problem);
        Algorithm algorithm = AlgorithmFactory.getInstance().getAlgorithm(algorithmName, properties, timingProblem);
        if (!properties.containsKey("maxEvaluations")) {
            throw new FrameworkException("maxEvaluations not defined");
        }
        int maxEvaluations = (int)Double.parseDouble(properties.getProperty("maxEvaluations"));
        long startTime = System.nanoTime();
        while (!algorithm.isTerminated() && algorithm.getNumberOfEvaluations() < maxEvaluations) {
            algorithm.step();
        }
        long endTime = System.nanoTime();
        NondominatedPopulation result = algorithm.getResult();
        algorithm.terminate();
        if (properties.containsKey("epsilon")) {
            TypedProperties typedProperties = new TypedProperties(properties);
            double[] epsilon = typedProperties.getDoubleArray("epsilon", null);
            result = EpsilonHelper.convert(result, epsilon);
        }
        Properties timingData = new Properties();
        timingData.setProperty("EvaluationTime", Double.toString(timingProblem.getTime()));
        timingData.setProperty("TotalTime", Double.toString((double)(endTime - startTime) / 1.0E9));
        this.output.append(new ResultEntry(result, timingData));
    }

    public static void main(String[] args) throws Exception {
        new Evaluator().start(args);
    }
}

