/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.ProblemStub;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileReader;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Indicator;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Problem;
import org.moeaframework.core.indicator.AdditiveEpsilonIndicator;
import org.moeaframework.core.indicator.Contribution;
import org.moeaframework.core.indicator.GenerationalDistance;
import org.moeaframework.core.indicator.Hypervolume;
import org.moeaframework.core.indicator.InvertedGenerationalDistance;
import org.moeaframework.core.indicator.MaximumParetoFrontError;
import org.moeaframework.core.indicator.R1Indicator;
import org.moeaframework.core.indicator.R2Indicator;
import org.moeaframework.core.indicator.R3Indicator;
import org.moeaframework.core.indicator.Spacing;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.OptionCompleter;
import org.moeaframework.util.TypedProperties;

public class ExtractData
extends CommandLineUtility {
    private Problem problem;
    private NondominatedPopulation referenceSet;

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        group.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"dimension");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number");
        group.addOption(OptionBuilder.create((char)'d'));
        options.addOptionGroup(group);
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"separator");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"reference");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"noheader");
        options.addOption(OptionBuilder.create((char)'n'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        String separator = commandLine.hasOption("separator") ? commandLine.getOptionValue("separator") : " ";
        String[] fields = commandLine.getArgs();
        ResultFileReader input = null;
        PrintStream output = null;
        try {
            this.problem = commandLine.hasOption("problem") ? ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem")) : new ProblemStub(Integer.parseInt(commandLine.getOptionValue("dimension")));
            try {
                input = new ResultFileReader(this.problem, new File(commandLine.getOptionValue("input")));
                try {
                    PrintStream printStream = output = commandLine.hasOption("output") ? new PrintStream(new File(commandLine.getOptionValue("output"))) : System.out;
                    if (!commandLine.hasOption("noheader")) {
                        output.print('#');
                        for (int i = 0; i < fields.length; ++i) {
                            if (i > 0) {
                                output.print(separator);
                            }
                            output.print(fields[i]);
                        }
                        output.println();
                    }
                    while (input.hasNext()) {
                        ResultEntry entry = input.next();
                        Properties properties = entry.getProperties();
                        for (int i = 0; i < fields.length; ++i) {
                            if (i > 0) {
                                output.print(separator);
                            }
                            if (properties.containsKey(fields[i])) {
                                output.print(properties.getProperty(fields[i]));
                                continue;
                            }
                            if (fields[i].startsWith("+")) {
                                output.print(this.evaluate(fields[i].substring(1), entry, commandLine));
                                continue;
                            }
                            throw new FrameworkException("missing field");
                        }
                        output.println();
                    }
                }
                finally {
                    if (output != null && output != System.out) {
                        output.close();
                    }
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        finally {
            if (this.problem != null) {
                this.problem.close();
            }
        }
    }

    protected String evaluate(String command, ResultEntry entry, CommandLine commandLine) throws IOException {
        OptionCompleter completer = new OptionCompleter("hypervolume", "generational", "inverted", "epsilon", "error", "spacing", "contribution", "R1", "R2", "R3");
        String option = completer.lookup(command);
        if (option == null) {
            throw new FrameworkException("unsupported command");
        }
        if (this.referenceSet == null) {
            this.referenceSet = commandLine.hasOption("reference") ? new NondominatedPopulation(PopulationIO.readObjectives(new File(commandLine.getOptionValue("reference")))) : ProblemFactory.getInstance().getReferenceSet(commandLine.getOptionValue("problem"));
            if (this.referenceSet == null) {
                throw new FrameworkException("no reference set available");
            }
        }
        Indicator indicator = null;
        if (option.equals("hypervolume")) {
            indicator = new Hypervolume(this.problem, this.referenceSet);
        } else if (option.equals("generational")) {
            indicator = new GenerationalDistance(this.problem, this.referenceSet);
        } else if (option.equals("inverted")) {
            indicator = new InvertedGenerationalDistance(this.problem, this.referenceSet);
        } else if (option.equals("epsilon")) {
            indicator = new AdditiveEpsilonIndicator(this.problem, this.referenceSet);
        } else if (option.equals("error")) {
            indicator = new MaximumParetoFrontError(this.problem, this.referenceSet);
        } else if (option.equals("spacing")) {
            indicator = new Spacing(this.problem);
        } else if (option.equals("contribution")) {
            if (commandLine.hasOption("epsilon")) {
                double[] epsilon = TypedProperties.withProperty("epsilon", commandLine.getOptionValue("epsilon")).getDoubleArray("epsilon", null);
                indicator = new Contribution(this.referenceSet, epsilon);
            } else {
                indicator = new Contribution(this.referenceSet);
            }
        } else if (option.equals("R1")) {
            indicator = new R1Indicator(this.problem, R1Indicator.getDefaultSubdivisions(this.problem), this.referenceSet);
        } else if (option.equals("R2")) {
            indicator = new R2Indicator(this.problem, R2Indicator.getDefaultSubdivisions(this.problem), this.referenceSet);
        } else if (option.equals("R3")) {
            indicator = new R3Indicator(this.problem, R3Indicator.getDefaultSubdivisions(this.problem), this.referenceSet);
        } else {
            throw new IllegalStateException();
        }
        return Double.toString(indicator.evaluate(entry.getPopulation()));
    }

    public static void main(String[] args) throws Exception {
        new ExtractData().start(args);
    }
}

