/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.util.ArrayList;
import java.util.List;

class FractalDimension {
    private static final double R_MAX = 0.25;
    private static final double R_MIN = 5.0E-4;

    private FractalDimension() {
    }

    private static double computeCorrelationSum(double[][] points, double r) {
        double sum = 0.0;
        int n = points.length;
        for (int i = 0; i <= n - 2; ++i) {
            for (int j = i + 1; j <= n - 1; ++j) {
                if (!(r - FractalDimension.distance(points[i], points[j]) >= 0.0)) continue;
                sum += 1.0;
            }
        }
        return sum / ((double)(n * (n - 1)) / 2.0);
    }

    private static double distance(double[] p1, double[] p2) {
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            sum += Math.pow(p2[i] - p1[i], 2.0);
        }
        return Math.sqrt(sum);
    }

    private static int getCorrelationDimensionBounds(List<Double> X, List<Double> Y) {
        int n = X.size();
        for (int i = 0; i < (n - 4) / 2; ++i) {
            double sumX = 0.0;
            double sumXX = 0.0;
            double sumY = 0.0;
            double sumXY = 0.0;
            double sumYY = 0.0;
            for (int j = i; j < n - i; ++j) {
                sumX += X.get(j).doubleValue();
                sumXX += X.get(j) * X.get(j);
                sumY += Y.get(j).doubleValue();
                sumXY += X.get(j) * Y.get(j);
                sumYY += Y.get(j) * Y.get(j);
            }
            int k = n - 2 * i;
            double correlationCoefficient = ((double)k * sumXY - sumX * sumY) / (Math.sqrt((double)k * sumXX - sumX * sumX) * Math.sqrt((double)k * sumYY - sumY * sumY));
            if (!(correlationCoefficient >= 0.99)) continue;
            return i;
        }
        return 0;
    }

    public static double computeDimension(double[][] parameters) {
        int remove;
        int n;
        if (parameters.length == 0) {
            return 0.0;
        }
        ArrayList<Double> X = new ArrayList<Double>();
        ArrayList<Double> Y = new ArrayList<Double>();
        for (double r = 0.25; r >= 5.0E-4; r -= 5.0E-4) {
            double lr = Math.log(r);
            double lc = Math.log(FractalDimension.computeCorrelationSum(parameters, r));
            if (lc == Double.NEGATIVE_INFINITY) break;
            X.add(lr);
            Y.add(lc);
        }
        if ((n = X.size()) < 5) {
            return 0.0;
        }
        double sumX = 0.0;
        double sumXX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        for (int i = remove = FractalDimension.getCorrelationDimensionBounds(X, Y); i < n - remove; ++i) {
            sumX += ((Double)X.get(i)).doubleValue();
            sumXX += (Double)X.get(i) * (Double)X.get(i);
            sumY += ((Double)Y.get(i)).doubleValue();
            sumXY += (Double)X.get(i) * (Double)Y.get(i);
        }
        return (sumX * sumY - (double)n * sumXY) / (sumX * sumX - (double)n * sumXX);
    }
}

