/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.util.io.CommentedLineReader;

class MatrixReader
implements Iterable<double[]>,
Iterator<double[]>,
Closeable {
    private final CommentedLineReader reader;
    private final int numberOfColumns;
    private double[] nextRow;
    private boolean error;
    private boolean suppressExceptions;

    public MatrixReader(File file) throws FileNotFoundException {
        this(new FileReader(file), -1);
    }

    public MatrixReader(File file, int numberOfColumns) throws FileNotFoundException {
        this(new FileReader(file), numberOfColumns);
    }

    public MatrixReader(Reader reader) {
        this(reader, -1);
    }

    public MatrixReader(Reader reader, int numberOfColumns) {
        this.reader = reader instanceof CommentedLineReader ? (CommentedLineReader)reader : new CommentedLineReader(reader);
        this.numberOfColumns = numberOfColumns;
    }

    @Override
    public Iterator<double[]> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.error) {
                return false;
            }
            if (this.nextRow == null) {
                this.nextRow = this.readNextRow();
            }
            return this.nextRow != null;
        }
        catch (IOException e) {
            throw new FrameworkException(e);
        }
    }

    @Override
    public double[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        double[] result = this.nextRow;
        this.nextRow = null;
        return result;
    }

    private double[] readNextRow() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        String[] tokens = line.trim().split("\\s+");
        if (this.numberOfColumns >= 0 && tokens.length != this.numberOfColumns) {
            this.error = true;
            if (this.suppressExceptions) {
                System.err.println("insufficient number of entries in row, ignoring remaining rows in the file");
                return null;
            }
            throw new IOException("insufficient number of entries in row");
        }
        double[] entry = new double[tokens.length];
        try {
            for (int i = 0; i < tokens.length; ++i) {
                entry[i] = Double.parseDouble(tokens[i]);
            }
        }
        catch (NumberFormatException e) {
            this.error = true;
            if (this.suppressExceptions) {
                return null;
            }
            throw new IOException("invalid entry in row", e);
        }
        return entry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Deprecated
    boolean isSupressExceptions() {
        return this.suppressExceptions;
    }

    @Deprecated
    void setSupressExceptions(boolean supressExceptions) {
        this.suppressExceptions = supressExceptions;
    }

    boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }
}

