/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.moeaframework.analysis.sensitivity.MetricFileReader;
import org.moeaframework.analysis.sensitivity.OutputWriter;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Settings;
import org.moeaframework.core.indicator.QualityIndicator;
import org.moeaframework.util.io.FileUtils;

public class MetricFileWriter
implements OutputWriter {
    public static final int NUMBER_OF_METRICS = 6;
    private final PrintWriter writer;
    private final QualityIndicator qualityIndicator;
    private int numberOfEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricFileWriter(QualityIndicator qualityIndicator, File file) throws IOException {
        this.qualityIndicator = qualityIndicator;
        File existingFile = new File(file.getParent(), "." + file.getName() + ".unclean");
        if (existingFile.exists()) {
            if (Settings.getCleanupStrategy().equalsIgnoreCase("restore")) {
                if (file.exists()) {
                    FileUtils.delete(existingFile);
                }
            } else if (Settings.getCleanupStrategy().equalsIgnoreCase("overwrite")) {
                FileUtils.delete(existingFile);
            } else {
                throw new FrameworkException("an unclean version of the file exists from a previous run, requires manual intervention");
            }
        }
        if (file.exists()) {
            FileUtils.move(file, existingFile);
        }
        this.numberOfEntries = 0;
        this.writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file)), true);
        this.writer.println("#Hypervolume GenerationalDistance InvertedGenerationalDistance Spacing EpsilonIndicator MaximumParetoFrontError");
        if (existingFile.exists()) {
            MetricFileReader reader = null;
            try {
                reader = new MetricFileReader(existingFile);
                while (reader.hasNext()) {
                    double[] data = reader.next();
                    this.writer.print(data[0]);
                    for (int i = 1; i < data.length; ++i) {
                        this.writer.print(' ');
                        this.writer.print(data[i]);
                    }
                    this.writer.println();
                    ++this.numberOfEntries;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            FileUtils.delete(existingFile);
        }
    }

    @Override
    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    @Override
    public void append(ResultEntry entry) {
        this.qualityIndicator.calculate(entry.getPopulation());
        this.writer.print(this.qualityIndicator.getHypervolume());
        this.writer.print(' ');
        this.writer.print(this.qualityIndicator.getGenerationalDistance());
        this.writer.print(' ');
        this.writer.print(this.qualityIndicator.getInvertedGenerationalDistance());
        this.writer.print(' ');
        this.writer.print(this.qualityIndicator.getSpacing());
        this.writer.print(' ');
        this.writer.print(this.qualityIndicator.getAdditiveEpsilonIndicator());
        this.writer.print(' ');
        this.writer.print(this.qualityIndicator.getMaximumParetoFrontError());
        this.writer.println();
        ++this.numberOfEntries;
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

