/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;

public class Negater
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"direction");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"d1,d2,...");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'d'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        TypedProperties properties = TypedProperties.withProperty("direction", commandLine.getOptionValue("direction"));
        int[] directions = properties.getIntArray("direction", null);
        block8: for (String filename : commandLine.getArgs()) {
            int j;
            String[] tokens;
            ArrayList<String> lines = new ArrayList<String>();
            String entry = null;
            BufferedReader reader = null;
            PrintStream writer = null;
            try {
                reader = new BufferedReader(new FileReader(filename));
                while ((entry = reader.readLine()) != null) {
                    lines.add(entry);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            for (String line : lines) {
                try {
                    if (line.startsWith("#") || line.startsWith("//")) continue;
                    tokens = line.split("\\s+");
                    if (tokens.length != directions.length) {
                        System.err.println("unable to negate values in " + filename + ", incorrect number of values in a row");
                        continue block8;
                    }
                    for (j = 0; j < tokens.length; ++j) {
                        if (directions[j] == 0) continue;
                        Double.parseDouble(tokens[j]);
                    }
                }
                catch (NumberFormatException e) {
                    System.err.println("unable to negate values in " + filename + ", unable to parse number");
                    continue block8;
                }
            }
            try {
                writer = new PrintStream(new File(filename));
                for (String line : lines) {
                    if (line.startsWith("#") || line.startsWith("//")) {
                        writer.println(line);
                        continue;
                    }
                    tokens = line.split("\\s+");
                    for (j = 0; j < tokens.length; ++j) {
                        if (j > 0) {
                            writer.print(' ');
                        }
                        if (directions[j] == 0) {
                            writer.print(tokens[j]);
                            continue;
                        }
                        double value = Double.parseDouble(tokens[j]);
                        writer.print(-value);
                    }
                    writer.println();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new Negater().start(args);
    }
}

