/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.moeaframework.analysis.sensitivity.Parameter;
import org.moeaframework.util.io.CommentedLineReader;

public class ParameterFile {
    private final List<Parameter> parameters;

    public ParameterFile(File file) throws IOException {
        this(new FileReader(file));
    }

    public ParameterFile(Reader reader) throws IOException {
        this.parameters = reader instanceof CommentedLineReader ? this.load((CommentedLineReader)reader) : this.load(new CommentedLineReader(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Parameter> load(CommentedLineReader reader) throws IOException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split("\\s+");
                if (tokens.length != 3) {
                    throw new IOException("expected only three items per line");
                }
                parameters.add(new Parameter(tokens[0], Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2])));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return parameters;
    }

    public int size() {
        return this.parameters.size();
    }

    public Parameter get(int index) {
        return this.parameters.get(index);
    }
}

