/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.EpsilonHelper;
import org.moeaframework.analysis.sensitivity.MetricFileWriter;
import org.moeaframework.analysis.sensitivity.ProblemStub;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileReader;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Problem;
import org.moeaframework.core.indicator.QualityIndicator;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;

public class ResultFileEvaluator
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        group.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"dimension");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number");
        group.addOption(OptionBuilder.create((char)'d'));
        options.addOptionGroup(group);
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"reference");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"force");
        options.addOption(OptionBuilder.create((char)'f'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        ResultFileReader reader = null;
        MetricFileWriter writer = null;
        Problem problem = null;
        NondominatedPopulation referenceSet = null;
        File inputFile = new File(commandLine.getOptionValue("input"));
        File outputFile = new File(commandLine.getOptionValue("output"));
        if (!commandLine.hasOption("force") && outputFile.lastModified() > 0L && inputFile.lastModified() > outputFile.lastModified()) {
            throw new FrameworkException("input appears to be newer than output");
        }
        referenceSet = commandLine.hasOption("reference") ? new NondominatedPopulation(PopulationIO.readObjectives(new File(commandLine.getOptionValue("reference")))) : ProblemFactory.getInstance().getReferenceSet(commandLine.getOptionValue("problem"));
        if (referenceSet == null) {
            throw new FrameworkException("no reference set available");
        }
        try {
            problem = commandLine.hasOption("problem") ? ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem")) : new ProblemStub(Integer.parseInt(commandLine.getOptionValue("dimension")));
            QualityIndicator indicator = new QualityIndicator(problem, referenceSet);
            try {
                reader = new ResultFileReader(problem, inputFile);
                try {
                    writer = new MetricFileWriter(indicator, outputFile);
                    for (int i = 0; i < writer.getNumberOfEntries(); ++i) {
                        if (!reader.hasNext()) {
                            throw new FrameworkException("output has more entries than input");
                        }
                        reader.next();
                    }
                    while (reader.hasNext()) {
                        ResultEntry entry = reader.next();
                        if (commandLine.hasOption("epsilon")) {
                            TypedProperties typedProperties = new TypedProperties();
                            typedProperties.getProperties().setProperty("epsilon", commandLine.getOptionValue("epsilon"));
                            double[] epsilon = typedProperties.getDoubleArray("epsilon", null);
                            entry = new ResultEntry((NondominatedPopulation)EpsilonHelper.convert(entry.getPopulation(), epsilon), entry.getProperties());
                        }
                        writer.append(entry);
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (problem != null) {
                problem.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new ResultFileEvaluator().start(args);
    }
}

