/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.ProblemStub;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileReader;
import org.moeaframework.analysis.sensitivity.ResultFileWriter;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;
import org.moeaframework.util.io.FileUtils;

public class ResultFileMerger
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        group.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"dimension");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number");
        group.addOption(OptionBuilder.create((char)'d'));
        options.addOptionGroup(group);
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"resultFile");
        options.addOption(OptionBuilder.create((char)'r'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        block17: {
            Problem problem = null;
            NondominatedPopulation mergedSet = null;
            ResultFileReader reader = null;
            if (commandLine.hasOption("epsilon")) {
                double[] epsilon = TypedProperties.withProperty("epsilon", commandLine.getOptionValue("epsilon")).getDoubleArray("epsilon", null);
                mergedSet = new EpsilonBoxDominanceArchive(epsilon);
            } else {
                mergedSet = new NondominatedPopulation();
            }
            try {
                problem = commandLine.hasOption("problem") ? ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem")) : new ProblemStub(Integer.parseInt(commandLine.getOptionValue("dimension")));
                for (String filename : commandLine.getArgs()) {
                    try {
                        reader = new ResultFileReader(problem, new File(filename));
                        while (reader.hasNext()) {
                            mergedSet.addAll(reader.next().getPopulation());
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                File output = new File(commandLine.getOptionValue("output"));
                if (commandLine.hasOption("resultFile")) {
                    ResultFileWriter writer = null;
                    FileUtils.delete(output);
                    try {
                        writer = new ResultFileWriter(problem, output);
                        writer.append(new ResultEntry(mergedSet));
                        break block17;
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                PopulationIO.writeObjectives(output, mergedSet);
            }
            finally {
                if (problem != null) {
                    problem.close();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new ResultFileMerger().start(args);
    }
}

