/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.variable.BinaryVariable;
import org.moeaframework.core.variable.Permutation;
import org.moeaframework.core.variable.RealVariable;

public class ResultFileReader
implements Closeable,
Iterator<ResultEntry>,
Iterable<ResultEntry> {
    private final BufferedReader reader;
    private String line;
    private final Problem problem;
    private ResultEntry nextEntry;
    private boolean error;
    private boolean printedWarning;

    public ResultFileReader(Problem problem, File file) throws IOException {
        this.problem = problem;
        this.reader = new BufferedReader(new FileReader(file));
        this.line = this.reader.readLine();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public ResultEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ResultEntry result = this.nextEntry;
        this.nextEntry = null;
        return result;
    }

    @Override
    public Iterator<ResultEntry> iterator() {
        return this;
    }

    private ResultEntry readNextEntry() throws NumberFormatException, IOException {
        NondominatedPopulation population = new NondominatedPopulation();
        StringWriter stringBuffer = new StringWriter();
        while (this.line != null && this.line.startsWith("#")) {
            this.line = this.reader.readLine();
        }
        while (this.line != null && !this.line.startsWith("#")) {
            if (this.line.startsWith("//")) {
                stringBuffer.write(this.line.substring(2));
                stringBuffer.write(10);
            } else {
                Solution solution = this.parseSolution(this.line);
                if (solution == null) {
                    System.err.println("unable to parse solution, ignoring remaining entries in the file");
                    return null;
                }
                population.add(solution);
            }
            this.line = this.reader.readLine();
        }
        Properties properties = new Properties();
        properties.load(new StringReader(stringBuffer.toString()));
        if (this.line == null || !this.line.startsWith("#")) {
            return null;
        }
        return new ResultEntry(population, properties);
    }

    private Solution parseSolution(String line) {
        String[] entries = line.trim().split("\\s+");
        Solution solution = null;
        if (entries.length < this.problem.getNumberOfObjectives()) {
            this.error = true;
            return null;
        }
        try {
            int i;
            if (entries.length == this.problem.getNumberOfVariables() + this.problem.getNumberOfObjectives()) {
                solution = this.problem.newSolution();
                for (i = 0; i < this.problem.getNumberOfVariables(); ++i) {
                    solution.setVariable(i, this.decode(solution.getVariable(i), entries[i]));
                }
            } else {
                solution = new Solution(0, this.problem.getNumberOfObjectives());
            }
            for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                solution.setObjective(i, Double.parseDouble(entries[entries.length - this.problem.getNumberOfObjectives() + i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error = true;
            return null;
        }
        return solution;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.error) {
                return false;
            }
            if (this.nextEntry == null) {
                this.nextEntry = this.readNextEntry();
            }
            return this.nextEntry != null;
        }
        catch (IOException e) {
            throw new FrameworkException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Variable decode(Variable variable, String string) {
        if (variable instanceof RealVariable) {
            RealVariable rv = (RealVariable)variable;
            rv.setValue(Double.parseDouble(string));
            return rv;
        }
        if (variable instanceof BinaryVariable) {
            BinaryVariable bv = (BinaryVariable)variable;
            if (bv.getNumberOfBits() != string.length()) {
                throw new FrameworkException("invalid bit string");
            }
            for (int i = 0; i < bv.getNumberOfBits(); ++i) {
                char c = string.charAt(i);
                if (c == '0') {
                    bv.set(i, false);
                    continue;
                }
                if (c == '1') {
                    bv.set(i, true);
                    continue;
                }
                throw new FrameworkException("invalid bit string");
            }
            return bv;
        }
        if (variable instanceof Permutation) {
            Permutation p = (Permutation)variable;
            String[] tokens = string.split(",");
            int[] array = new int[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = Integer.parseInt(tokens[i]);
            }
            try {
                p.fromArray(array);
            }
            catch (IllegalArgumentException e) {
                throw new FrameworkException("invalid permutation", e);
            }
            return p;
        }
        if (string.equals("-")) {
            if (!this.printedWarning) {
                System.err.println("unsupported decision variable type, may become unstable");
                this.printedWarning = true;
            }
            return variable;
        }
        try {
            return this.deserialize(string);
        }
        catch (Exception e) {
            throw new FrameworkException("deserialization failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Variable deserialize(String string) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = null;
        try {
            byte[] encoding = Base64.decodeBase64((String)string);
            ByteArrayInputStream baos = new ByteArrayInputStream(encoding);
            ois = new ObjectInputStream(baos);
            Variable variable = (Variable)ois.readObject();
            return variable;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }
}

