/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.ProblemStub;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileReader;
import org.moeaframework.analysis.sensitivity.ResultFileWriter;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;

public class ResultFileSeedMerger
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        group.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"dimension");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number");
        group.addOption(OptionBuilder.create((char)'d'));
        options.addOptionGroup(group);
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NondominatedPopulation> load(File file, Problem problem) throws IOException {
        ResultFileReader reader = null;
        try {
            reader = new ResultFileReader(problem, file);
            ArrayList<NondominatedPopulation> data = new ArrayList<NondominatedPopulation>();
            while (reader.hasNext()) {
                data.add(reader.next().getPopulation());
            }
            ArrayList<NondominatedPopulation> arrayList = data;
            return arrayList;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        ArrayList<List<NondominatedPopulation>> entries = new ArrayList<List<NondominatedPopulation>>();
        Problem problem = null;
        ResultFileWriter writer = null;
        try {
            int i;
            problem = commandLine.hasOption("problem") ? ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem")) : new ProblemStub(Integer.parseInt(commandLine.getOptionValue("dimension")));
            for (String filename : commandLine.getArgs()) {
                entries.add(this.load(new File(filename), problem));
            }
            if (entries.isEmpty()) {
                throw new IllegalArgumentException("requires at least one file");
            }
            int numberOfEntries = -1;
            for (i = 0; i < entries.size(); ++i) {
                if (numberOfEntries < 0) {
                    numberOfEntries = ((List)entries.get(i)).size();
                    continue;
                }
                if (numberOfEntries == ((List)entries.get(i)).size()) continue;
                throw new IllegalArgumentException("unbalanced number of entries: " + commandLine.getArgs()[i]);
            }
            try {
                writer = new ResultFileWriter(problem, new File(commandLine.getOptionValue("output")));
                for (i = 0; i < numberOfEntries; ++i) {
                    NondominatedPopulation mergedSet = null;
                    if (commandLine.hasOption("epsilon")) {
                        double[] epsilon = TypedProperties.withProperty("epsilon", commandLine.getOptionValue("epsilon")).getDoubleArray("epsilon", null);
                        mergedSet = new EpsilonBoxDominanceArchive(epsilon);
                    } else {
                        mergedSet = new NondominatedPopulation();
                    }
                    for (int j = 0; j < entries.size(); ++j) {
                        mergedSet.addAll((Iterable)((List)entries.get(j)).get(i));
                    }
                    writer.append(new ResultEntry(mergedSet));
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (problem != null) {
                problem.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new ResultFileSeedMerger().start(args);
    }
}

