/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.moeaframework.analysis.sensitivity.OutputWriter;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileReader;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Settings;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.variable.BinaryVariable;
import org.moeaframework.core.variable.Permutation;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.util.io.FileUtils;

public class ResultFileWriter
implements OutputWriter {
    protected static final String ENCODING_WARNING = "unsupported decision variable type, may become unstable";
    protected static final String NO_VARIABLES_WARNING = "saving result file without variables, may become unstable";
    protected static final String EXISTING_FILE = "an unclean version of the file exists from a previous run, requires manual intervention";
    private final PrintWriter writer;
    private final boolean includeVariables;
    private int numberOfEntries;
    private boolean printedWarning;

    public ResultFileWriter(Problem problem, File file) throws IOException {
        this(problem, file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultFileWriter(Problem problem, File file, boolean includeVariables) throws IOException {
        File existingFile;
        this.includeVariables = includeVariables;
        if (!includeVariables) {
            System.err.println(NO_VARIABLES_WARNING);
        }
        if ((existingFile = new File(file.getParent(), "." + file.getName() + ".unclean")).exists()) {
            if (Settings.getCleanupStrategy().equalsIgnoreCase("restore")) {
                if (file.exists()) {
                    FileUtils.delete(existingFile);
                }
            } else if (Settings.getCleanupStrategy().equalsIgnoreCase("overwrite")) {
                FileUtils.delete(existingFile);
            } else {
                throw new FrameworkException(EXISTING_FILE);
            }
        }
        if (file.exists()) {
            FileUtils.move(file, existingFile);
        }
        this.numberOfEntries = 0;
        this.writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file)), true);
        this.writer.print("# Problem = ");
        this.writer.println(problem.getName());
        if (includeVariables) {
            this.writer.print("# Variables = ");
            this.writer.println(problem.getNumberOfVariables());
        }
        this.writer.print("# Objectives = ");
        this.writer.println(problem.getNumberOfObjectives());
        if (existingFile.exists()) {
            ResultFileReader reader = null;
            try {
                reader = new ResultFileReader(problem, existingFile);
                while (reader.hasNext()) {
                    this.append(reader.next());
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            FileUtils.delete(existingFile);
        }
    }

    @Override
    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    @Override
    public void append(ResultEntry entry) throws IOException {
        ++this.numberOfEntries;
        ArrayList<Solution> feasibleSolutions = new ArrayList<Solution>();
        for (Solution solution : entry.getPopulation()) {
            if (solution.violatesConstraints()) continue;
            feasibleSolutions.add(solution);
        }
        Properties properties = entry.getProperties();
        if (feasibleSolutions.isEmpty() && (properties == null || properties.isEmpty())) {
            this.writer.println("//");
        }
        if (properties != null && !properties.isEmpty()) {
            this.printProperties(properties);
        }
        if (!feasibleSolutions.isEmpty()) {
            for (Solution solution : feasibleSolutions) {
                this.printSolution(solution);
            }
        }
        this.writer.println('#');
    }

    private void printSolution(Solution solution) {
        int i;
        if (this.includeVariables) {
            for (i = 0; i < solution.getNumberOfVariables(); ++i) {
                if (i > 0) {
                    this.writer.print(' ');
                }
                this.writer.print(this.encode(solution.getVariable(i)));
            }
        }
        for (i = 0; i < solution.getNumberOfObjectives(); ++i) {
            if (i > 0 || this.includeVariables && solution.getNumberOfVariables() > 0) {
                this.writer.print(' ');
            }
            this.writer.print(solution.getObjective(i));
        }
        this.writer.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printProperties(Properties properties) throws IOException {
        StringWriter stringBuffer = new StringWriter();
        BufferedReader reader = null;
        properties.store(stringBuffer, null);
        try {
            reader = new BufferedReader(new StringReader(stringBuffer.toString()));
            reader.readLine();
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.writer.print("//");
                this.writer.println(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String encode(Variable variable) {
        StringBuilder sb = new StringBuilder();
        if (variable instanceof RealVariable) {
            RealVariable rv = (RealVariable)variable;
            sb.append(rv.getValue());
            return sb.toString();
        } else if (variable instanceof BinaryVariable) {
            BinaryVariable bv = (BinaryVariable)variable;
            for (int i = 0; i < bv.getNumberOfBits(); ++i) {
                sb.append(bv.get(i) ? "1" : "0");
            }
            return sb.toString();
        } else if (variable instanceof Permutation) {
            Permutation p = (Permutation)variable;
            for (int i = 0; i < p.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(p.get(i));
            }
            return sb.toString();
        } else {
            try {
                sb.append(this.serialize(variable));
                return sb.toString();
            }
            catch (IOException e) {
                sb.append('-');
                if (this.printedWarning) return sb.toString();
                System.err.println(ENCODING_WARNING);
                this.printedWarning = true;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serialize(Variable variable) throws IOException {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(variable);
            byte[] encoding = Base64.encodeBase64((byte[])baos.toByteArray(), (boolean)false);
            String string = StringUtils.newStringUtf8((byte[])encoding);
            return string;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }
}

