/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.ParameterFile;
import org.moeaframework.core.PRNG;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.OptionCompleter;
import org.moeaframework.util.sequence.LatinHypercube;
import org.moeaframework.util.sequence.Saltelli;
import org.moeaframework.util.sequence.Sobol;
import org.moeaframework.util.sequence.Uniform;

public class SampleGenerator
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"numberOfSamples");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withLongOpt((String)"parameterFile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"method");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withLongOpt((String)"seed");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'o'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(CommandLine commandLine) throws IOException {
        ParameterFile parameterFile = new ParameterFile(new File(commandLine.getOptionValue("parameterFile")));
        int N = Integer.parseInt(commandLine.getOptionValue("numberOfSamples"));
        int D = parameterFile.size();
        if (N <= 0) {
            throw new IllegalArgumentException("numberOfSamples must be positive");
        }
        if (D <= 0) {
            throw new IllegalArgumentException("parameter file contains no parameters");
        }
        Object var5_5 = null;
        if (commandLine.hasOption("method")) {
            OptionCompleter completer = new OptionCompleter("uniform", "latin", "sobol", "saltelli");
            String method = completer.lookup(commandLine.getOptionValue("method"));
            if (method == null) {
                throw new IllegalArgumentException("invalid method: " + commandLine.getOptionValue("method"));
            }
            if (method.equals("latin")) {
                LatinHypercube latinHypercube = new LatinHypercube();
            } else if (method.equals("sobol")) {
                Sobol sobol = new Sobol();
            } else if (method.equals("saltelli")) {
                N *= 2 * D + 2;
                Saltelli saltelli = new Saltelli();
            } else {
                if (!method.equals("uniform")) throw new IllegalArgumentException("invalid method: " + commandLine.getOptionValue("method"));
                Uniform uniform = new Uniform();
            }
        } else {
            Sobol sobol = new Sobol();
        }
        if (commandLine.hasOption("seed")) {
            PRNG.setSeed(Long.parseLong(commandLine.getOptionValue("seed")));
        }
        PrintStream output = System.out;
        try {
            void var5_12;
            if (commandLine.hasOption("output")) {
                output = new PrintStream(new BufferedOutputStream(new FileOutputStream(commandLine.getOptionValue("output"))));
            }
            double[][] samples = var5_12.generate(N, D);
            for (int i = 0; i < N; ++i) {
                output.print(parameterFile.get(0).getLowerBound() + samples[i][0] * (parameterFile.get(0).getUpperBound() - parameterFile.get(0).getLowerBound()));
                for (int j = 1; j < D; ++j) {
                    output.print(' ');
                    output.print(parameterFile.get(j).getLowerBound() + samples[i][j] * (parameterFile.get(j).getUpperBound() - parameterFile.get(j).getLowerBound()));
                }
                output.println();
            }
            return;
        }
        finally {
            if (output != null && output != System.out) {
                output.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new SampleGenerator().start(args);
    }
}

