/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Properties;
import org.moeaframework.analysis.sensitivity.MatrixReader;
import org.moeaframework.analysis.sensitivity.Parameter;
import org.moeaframework.analysis.sensitivity.ParameterFile;
import org.moeaframework.core.FrameworkException;

public class SampleReader
implements Iterable<Properties>,
Iterator<Properties>,
Closeable {
    private final MatrixReader reader;
    private final ParameterFile parameterFile;

    public SampleReader(File file, ParameterFile parameterFile) throws IOException {
        this(new MatrixReader(file, parameterFile.size()), parameterFile);
    }

    public SampleReader(Reader reader, ParameterFile parameterFile) {
        this(new MatrixReader(reader, parameterFile.size()), parameterFile);
    }

    private SampleReader(MatrixReader reader, ParameterFile parameterFile) {
        this.reader = reader;
        this.parameterFile = parameterFile;
    }

    @Override
    public Iterator<Properties> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public Properties next() {
        double[] values = this.reader.next();
        Properties parameters = new Properties();
        for (int i = 0; i < values.length; ++i) {
            Parameter parameter = this.parameterFile.get(i);
            if (values[i] < parameter.getLowerBound() || values[i] > parameter.getUpperBound()) {
                throw new FrameworkException("parameter out of bounds");
            }
            parameters.setProperty(this.parameterFile.get(i).getName(), Double.toString(values[i]));
        }
        return parameters;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

