/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.indicator.Contribution;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;

public class SetContribution
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"reference");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        return options;
    }

    @Override
    public void run(CommandLine commandLine) throws Exception {
        NondominatedPopulation referenceSet = new NondominatedPopulation(PopulationIO.readObjectives(new File(commandLine.getOptionValue("reference"))));
        Contribution contribution = null;
        if (commandLine.hasOption("epsilon")) {
            double[] epsilon = TypedProperties.withProperty("epsilon", commandLine.getOptionValue("epsilon")).getDoubleArray("epsilon", null);
            contribution = new Contribution(referenceSet, epsilon);
        } else {
            contribution = new Contribution(referenceSet);
        }
        for (String filename : commandLine.getArgs()) {
            NondominatedPopulation approximationSet = new NondominatedPopulation(PopulationIO.readObjectives(new File(filename)));
            System.out.print(filename);
            System.out.print(' ');
            System.out.println(contribution.evaluate(approximationSet));
        }
    }

    public static void main(String[] args) throws Exception {
        new SetContribution().start(args);
    }
}

