/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.problem.AnalyticalProblem;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;

public class SetGenerator
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"numberOfPoints");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withLongOpt((String)"seed");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws IOException {
        NondominatedPopulation set;
        block9: {
            set = null;
            Problem problem = null;
            int numberOfPoints = Integer.parseInt(commandLine.getOptionValue("numberOfPoints"));
            if (commandLine.hasOption("epsilon")) {
                double[] epsilon = TypedProperties.withProperty("epsilon", commandLine.getOptionValue("epsilon")).getDoubleArray("epsilon", null);
                set = new EpsilonBoxDominanceArchive(epsilon);
            } else {
                set = new NondominatedPopulation();
            }
            if (commandLine.hasOption("seed")) {
                PRNG.setSeed(Long.parseLong(commandLine.getOptionValue("seed")));
            }
            try {
                problem = ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem"));
                if (problem instanceof AnalyticalProblem) {
                    AnalyticalProblem generator = (AnalyticalProblem)problem;
                    for (int i = 0; i < numberOfPoints; ++i) {
                        set.add(generator.generate());
                    }
                    break block9;
                }
                throw new FrameworkException("problem does not have an analytical solution");
            }
            finally {
                if (problem != null) {
                    problem.close();
                }
            }
        }
        PopulationIO.writeObjectives(new File(commandLine.getOptionValue("output")), set);
    }

    public static void main(String[] args) throws Exception {
        new SetGenerator().start(args);
    }
}

