/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.ProblemStub;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Solution;
import org.moeaframework.core.indicator.Hypervolume;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;

public class SetHypervolume
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        return options;
    }

    @Override
    public void run(CommandLine commandLine) throws Exception {
        for (String filename : commandLine.getArgs()) {
            NondominatedPopulation set = new NondominatedPopulation(PopulationIO.readObjectives(new File(filename)));
            if (commandLine.hasOption("epsilon")) {
                TypedProperties typedProperties = TypedProperties.withProperty("epsilon", commandLine.getOptionValue("epsilon"));
                set = new EpsilonBoxDominanceArchive(typedProperties.getDoubleArray("epsilon", null), (Iterable<? extends Solution>)set);
            }
            System.out.print(filename);
            System.out.print(' ');
            System.out.println(new Hypervolume(new ProblemStub(set.get(0).getNumberOfObjectives()), set).evaluate(set));
        }
    }

    public static void main(String[] args) throws Exception {
        new SetHypervolume().start(args);
    }
}

