/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.moeaframework.analysis.sensitivity.MatrixReader;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.OptionCompleter;

public class SimpleStatistics
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"mode");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"ignore");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"maximum");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'x'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[][] load(File file) throws IOException {
        MatrixReader reader = null;
        try {
            reader = new MatrixReader(file);
            ArrayList<double[]> data = new ArrayList<double[]>();
            while (reader.hasNext()) {
                data.add(reader.next());
            }
            double[][] dArray = (double[][])data.toArray((T[])new double[0][]);
            return dArray;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        int i;
        String mode = null;
        PrintStream out = null;
        ArrayList<double[][]> entries = new ArrayList<double[][]>();
        SummaryStatistics statistics = new SummaryStatistics();
        OptionCompleter completer = new OptionCompleter("minimum", "maximum", "average", "stdev", "count");
        for (String filename : commandLine.getArgs()) {
            entries.add(this.load(new File(filename)));
        }
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("requires at least one file");
        }
        int numberOfRows = -1;
        int numberOfColumns = -1;
        for (i = 0; i < entries.size(); ++i) {
            if (numberOfRows == -1) {
                numberOfRows = ((double[][])entries.get(i)).length;
                if (numberOfRows == 0) {
                    throw new IllegalArgumentException("empty file: " + commandLine.getArgs()[i]);
                }
            } else if (numberOfRows != ((double[][])entries.get(i)).length) {
                throw new IllegalArgumentException("unbalanced rows: " + commandLine.getArgs()[i]);
            }
            if (numberOfColumns == -1) {
                numberOfColumns = ((double[][])entries.get(i))[0].length;
                continue;
            }
            if (numberOfColumns == ((double[][])entries.get(i))[0].length) continue;
            throw new IllegalArgumentException("unbalanced columns: " + commandLine.getArgs()[i]);
        }
        if (commandLine.hasOption("mode")) {
            mode = completer.lookup(commandLine.getOptionValue("mode"));
            if (mode == null) {
                throw new IllegalArgumentException("invalid mode");
            }
        } else {
            mode = "average";
        }
        try {
            out = commandLine.hasOption("output") ? new PrintStream(commandLine.getOptionValue("output")) : System.out;
            for (i = 0; i < numberOfRows; ++i) {
                for (int j = 0; j < numberOfColumns; ++j) {
                    statistics.clear();
                    for (int k = 0; k < entries.size(); ++k) {
                        double value = ((double[][])entries.get(k))[i][j];
                        if (Double.isInfinite(value) && commandLine.hasOption("maximum")) {
                            value = Double.parseDouble(commandLine.getOptionValue("maximum"));
                        }
                        if ((Double.isInfinite(value) || Double.isNaN(value)) && commandLine.hasOption("ignore")) continue;
                        statistics.addValue(value);
                    }
                    if (j > 0) {
                        out.print(' ');
                    }
                    if (mode.equals("minimum")) {
                        out.print(statistics.getMin());
                        continue;
                    }
                    if (mode.equals("maximum")) {
                        out.print(statistics.getMax());
                        continue;
                    }
                    if (mode.equals("average")) {
                        out.print(statistics.getMean());
                        continue;
                    }
                    if (mode.equals("stdev")) {
                        out.print(statistics.getStandardDeviation());
                        continue;
                    }
                    if (mode.equals("count")) {
                        out.print(statistics.getN());
                        continue;
                    }
                    throw new IllegalArgumentException("unknown mode: " + mode);
                }
                out.println();
            }
        }
        finally {
            if (out != null && out != System.out) {
                out.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new SimpleStatistics().start(args);
    }
}

