/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.sensitivity;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.stat.StatUtils;
import org.moeaframework.analysis.sensitivity.MatrixReader;
import org.moeaframework.analysis.sensitivity.ParameterFile;
import org.moeaframework.core.PRNG;
import org.moeaframework.util.CommandLineUtility;

public class SobolAnalysis
extends CommandLineUtility {
    private int resamples = 1000;
    private ParameterFile parameterFile;
    private int P;
    private int N;
    private int index;
    private double[] A;
    private double[] B;
    private double[][] C_A;
    private double[][] C_B;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file) throws IOException {
        MatrixReader reader = null;
        try {
            reader = new MatrixReader(file);
            this.A = new double[this.N];
            this.B = new double[this.N];
            this.C_A = new double[this.N][this.P];
            this.C_B = new double[this.N][this.P];
            for (int i = 0; i < this.N; ++i) {
                int j;
                this.A[i] = reader.next()[this.index];
                for (j = 0; j < this.P; ++j) {
                    this.C_A[i][j] = reader.next()[this.index];
                }
                for (j = 0; j < this.P; ++j) {
                    this.C_B[i][j] = reader.next()[this.index];
                }
                this.B[i] = reader.next()[this.index];
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void display(PrintStream output) {
        int i;
        double[] a2;
        double[] a1;
        double[] a0;
        int j;
        output.println("Parameter\tSensitivity [Confidence]");
        output.println("First-Order Effects");
        for (j = 0; j < this.P; ++j) {
            a0 = new double[this.N];
            a1 = new double[this.N];
            a2 = new double[this.N];
            for (i = 0; i < this.N; ++i) {
                a0[i] = this.A[i];
                a1[i] = this.C_A[i][j];
                a2[i] = this.B[i];
            }
            output.print("  ");
            output.print(this.parameterFile.get(j).getName());
            output.print(' ');
            output.print(SobolAnalysis.computeFirstOrder(a0, a1, a2, this.N));
            output.print(" [");
            output.print(SobolAnalysis.computeFirstOrderConfidence(a0, a1, a2, this.N, this.resamples));
            output.println(']');
        }
        output.println("Total-Order Effects");
        for (j = 0; j < this.P; ++j) {
            a0 = new double[this.N];
            a1 = new double[this.N];
            a2 = new double[this.N];
            for (i = 0; i < this.N; ++i) {
                a0[i] = this.A[i];
                a1[i] = this.C_A[i][j];
                a2[i] = this.B[i];
            }
            output.print("  ");
            output.print(this.parameterFile.get(j).getName());
            output.print(' ');
            output.print(SobolAnalysis.computeTotalOrder(a0, a1, a2, this.N));
            output.print(" [");
            output.print(SobolAnalysis.computeTotalOrderConfidence(a0, a1, a2, this.N, this.resamples));
            output.println(']');
        }
        output.println("Second-Order Effects");
        for (j = 0; j < this.P; ++j) {
            for (int k = j + 1; k < this.P; ++k) {
                double[] a02 = new double[this.N];
                double[] a12 = new double[this.N];
                double[] a22 = new double[this.N];
                double[] a3 = new double[this.N];
                double[] a4 = new double[this.N];
                for (int i2 = 0; i2 < this.N; ++i2) {
                    a02[i2] = this.A[i2];
                    a12[i2] = this.C_B[i2][j];
                    a22[i2] = this.C_A[i2][k];
                    a3[i2] = this.C_A[i2][j];
                    a4[i2] = this.B[i2];
                }
                output.print("  ");
                output.print(this.parameterFile.get(j).getName());
                output.print(" * ");
                output.print(this.parameterFile.get(k).getName());
                output.print(' ');
                output.print(SobolAnalysis.computeSecondOrder(a02, a12, a22, a3, a4, this.N));
                output.print(" [");
                output.print(SobolAnalysis.computeSecondOrderConfidence(a02, a12, a22, a3, a4, this.N, this.resamples));
                output.println(']');
            }
        }
    }

    private void displaySimple(PrintStream output) {
        double value;
        double[] a2;
        double[] a1;
        double[] a0;
        int j;
        output.println("First-Order Effects");
        for (j = 0; j < this.P; ++j) {
            a0 = new double[this.N];
            a1 = new double[this.N];
            a2 = new double[this.N];
            for (int i = 0; i < this.N; ++i) {
                a0[i] = this.A[i];
                a1[i] = this.C_A[i][j];
                a2[i] = this.B[i];
            }
            value = SobolAnalysis.computeFirstOrder(a0, a1, a2, this.N);
            output.print(value < 0.0 ? 0.0 : value);
            if (j >= this.P - 1) continue;
            output.print('\t');
        }
        output.println();
        output.println("Total-Order Effects");
        for (j = 0; j < this.P; ++j) {
            a0 = new double[this.N];
            a1 = new double[this.N];
            a2 = new double[this.N];
            for (int i = 0; i < this.N; ++i) {
                a0[i] = this.A[i];
                a1[i] = this.C_A[i][j];
                a2[i] = this.B[i];
            }
            value = SobolAnalysis.computeTotalOrder(a0, a1, a2, this.N);
            output.print(value < 0.0 ? 0.0 : value);
            if (j >= this.P - 1) continue;
            output.print('\t');
        }
        output.println();
    }

    private static double computeFirstOrderConfidence(double[] a0, double[] a1, double[] a2, int nsample, int nresample) {
        double[] b0 = new double[nsample];
        double[] b1 = new double[nsample];
        double[] b2 = new double[nsample];
        double[] s = new double[nresample];
        for (int i = 0; i < nresample; ++i) {
            for (int j = 0; j < nsample; ++j) {
                int index = PRNG.nextInt(nsample);
                b0[j] = a0[index];
                b1[j] = a1[index];
                b2[j] = a2[index];
            }
            s[i] = SobolAnalysis.computeFirstOrder(b0, b1, b2, nsample);
        }
        double ss = StatUtils.sum((double[])s) / (double)nresample;
        double sss = 0.0;
        for (int i = 0; i < nresample; ++i) {
            sss += Math.pow(s[i] - ss, 2.0);
        }
        return 1.96 * Math.sqrt(sss / (double)(nresample - 1));
    }

    private static double computeFirstOrder(double[] a0, double[] a1, double[] a2, int nsample) {
        double c = 0.0;
        for (int i = 0; i < nsample; ++i) {
            c += a0[i];
        }
        c /= (double)nsample;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmp3 = 0.0;
        double EY2 = 0.0;
        for (int i = 0; i < nsample; ++i) {
            EY2 += (a0[i] - c) * (a2[i] - c);
            tmp1 += (a2[i] - c) * (a2[i] - c);
            tmp2 += a2[i] - c;
            tmp3 += (a1[i] - c) * (a2[i] - c);
        }
        double V = tmp1 / (double)(nsample - 1) - Math.pow(tmp2 / (double)nsample, 2.0);
        double U = tmp3 / (double)(nsample - 1);
        return (U - (EY2 /= (double)nsample)) / V;
    }

    private static double computeTotalOrder(double[] a0, double[] a1, double[] a2, int nsample) {
        double c = 0.0;
        for (int i = 0; i < nsample; ++i) {
            c += a0[i];
        }
        c /= (double)nsample;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmp3 = 0.0;
        for (int i = 0; i < nsample; ++i) {
            tmp1 += (a0[i] - c) * (a0[i] - c);
            tmp2 += (a0[i] - c) * (a1[i] - c);
            tmp3 += a0[i] - c;
        }
        double EY2 = Math.pow(tmp3 / (double)nsample, 2.0);
        double V = tmp1 / (double)(nsample - 1) - EY2;
        double U = tmp2 / (double)(nsample - 1);
        return 1.0 - (U - EY2) / V;
    }

    private static double computeTotalOrderConfidence(double[] a0, double[] a1, double[] a2, int nsample, int nresample) {
        double[] b0 = new double[nsample];
        double[] b1 = new double[nsample];
        double[] b2 = new double[nsample];
        double[] s = new double[nresample];
        for (int i = 0; i < nresample; ++i) {
            for (int j = 0; j < nsample; ++j) {
                int index = PRNG.nextInt(nsample);
                b0[j] = a0[index];
                b1[j] = a1[index];
                b2[j] = a2[index];
            }
            s[i] = SobolAnalysis.computeTotalOrder(b0, b1, b2, nsample);
        }
        double ss = StatUtils.sum((double[])s) / (double)nresample;
        double sss = 0.0;
        for (int i = 0; i < nresample; ++i) {
            sss += Math.pow(s[i] - ss, 2.0);
        }
        return 1.96 * Math.sqrt(sss / (double)(nresample - 1));
    }

    private static double computeSecondOrder(double[] a0, double[] a1, double[] a2, double[] a3, double[] a4, int nsample) {
        double c = 0.0;
        for (int i = 0; i < nsample; ++i) {
            c += a0[i];
        }
        c /= (double)nsample;
        double EY = 0.0;
        double EY2 = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmp3 = 0.0;
        double tmp4 = 0.0;
        double tmp5 = 0.0;
        for (int i = 0; i < nsample; ++i) {
            EY += (a0[i] - c) * (a4[i] - c);
            EY2 += (a1[i] - c) * (a3[i] - c);
            tmp1 += (a1[i] - c) * (a1[i] - c);
            tmp2 += a1[i] - c;
            tmp3 += (a1[i] - c) * (a2[i] - c);
            tmp4 += (a2[i] - c) * (a4[i] - c);
            tmp5 += (a3[i] - c) * (a4[i] - c);
        }
        double V = tmp1 / (double)(nsample - 1) - Math.pow(tmp2 / (double)nsample, 2.0);
        double Vij = tmp3 / (double)(nsample - 1) - (EY2 /= (double)nsample);
        double Vi = tmp4 / (double)(nsample - 1) - (EY /= (double)nsample);
        double Vj = tmp5 / (double)(nsample - 1) - EY2;
        return (Vij - Vi - Vj) / V;
    }

    private static double computeSecondOrderConfidence(double[] a0, double[] a1, double[] a2, double[] a3, double[] a4, int nsample, int nresample) {
        double[] b0 = new double[nsample];
        double[] b1 = new double[nsample];
        double[] b2 = new double[nsample];
        double[] b3 = new double[nsample];
        double[] b4 = new double[nsample];
        double[] s = new double[nresample];
        for (int i = 0; i < nresample; ++i) {
            for (int j = 0; j < nsample; ++j) {
                int index = PRNG.nextInt(nsample);
                b0[j] = a0[index];
                b1[j] = a1[index];
                b2[j] = a2[index];
                b3[j] = a3[index];
                b4[j] = a4[index];
            }
            s[i] = SobolAnalysis.computeSecondOrder(b0, b1, b2, b3, b4, nsample);
        }
        double ss = StatUtils.sum((double[])s) / (double)nresample;
        double sss = 0.0;
        for (int i = 0; i < nresample; ++i) {
            sss += Math.pow(s[i] - ss, 2.0);
        }
        return 1.96 * Math.sqrt(sss / (double)(nresample - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int validate(File file) throws IOException {
        MatrixReader reader = null;
        try {
            reader = new MatrixReader(file);
            int count = 0;
            while (reader.hasNext() && reader.next().length > this.index) {
                ++count;
            }
            if (count % (2 * this.P + 2) != 0) {
                System.err.println(file + " is incomplete");
            }
            int n = count / (2 * this.P + 2);
            return n;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"parameterFile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"metric");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withLongOpt((String)"simple");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"resamples");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number");
        options.addOption(OptionBuilder.create((char)'r'));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        PrintStream output = null;
        this.parameterFile = new ParameterFile(new File(commandLine.getOptionValue("parameterFile")));
        this.index = Integer.parseInt(commandLine.getOptionValue("metric"));
        this.P = this.parameterFile.size();
        if (commandLine.hasOption("resamples")) {
            this.resamples = Integer.parseInt(commandLine.getOptionValue("resamples"));
        }
        File input = new File(commandLine.getOptionValue("input"));
        this.N = this.validate(input);
        this.load(input);
        try {
            output = commandLine.hasOption("output") ? new PrintStream(new File(commandLine.getOptionValue("output"))) : System.out;
            if (commandLine.hasOption("simple")) {
                this.displaySimple(output);
            } else {
                this.display(output);
            }
        }
        finally {
            if (output != null && output != System.out) {
                output.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new SobolAnalysis().start(args);
    }
}

