/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.ProblemStub;
import org.moeaframework.analysis.sensitivity.ResultFileReader;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.util.CommandLineUtility;

public class ARFFConverter
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        group.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"dimension");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number");
        group.addOption(OptionBuilder.create((char)'d'));
        options.addOptionGroup(group);
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"reduced");
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"names");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'n'));
        return options;
    }

    private void printHeader(Problem problem, boolean reduced, List<String> attributes, PrintWriter writer) {
        int numberOfVariables = problem.getNumberOfVariables();
        int numberOfObjectives = problem.getNumberOfObjectives();
        if (reduced) {
            numberOfVariables = 0;
        }
        writer.println("% Title: MOEA Framework Data Set");
        writer.println("% Date: " + new Date());
        writer.print("@RELATION \"");
        writer.print(problem.getName());
        writer.println("\"");
        if (attributes.size() == numberOfObjectives) {
            int i;
            for (i = 0; i < numberOfVariables; ++i) {
                writer.print("@ATTRIBUTE Var");
                writer.print(i + 1);
                writer.println(" NUMERIC");
            }
            for (i = 0; i < numberOfObjectives; ++i) {
                writer.print("@ATTRIBUTE ");
                writer.print(attributes.get(i));
                writer.println(" NUMERIC");
            }
        } else if (attributes.size() == numberOfVariables + numberOfObjectives) {
            for (int i = 0; i < numberOfVariables + numberOfObjectives; ++i) {
                writer.print("@ATTRIBUTE ");
                writer.print(attributes.get(i));
                writer.println(" NUMERIC");
            }
        } else {
            int i;
            if (!attributes.isEmpty()) {
                System.err.println("incorrect number of names, using defaults");
            }
            for (i = 0; i < numberOfVariables; ++i) {
                writer.print("@ATTRIBUTE Var");
                writer.print(i + 1);
                writer.println(" NUMERIC");
            }
            for (i = 0; i < numberOfObjectives; ++i) {
                writer.print("@ATTRIBUTE Obj");
                writer.print(i + 1);
                writer.println(" NUMERIC");
            }
        }
        writer.println("@DATA");
    }

    private void printData(Problem problem, boolean reduced, Population population, PrintWriter writer) {
        int numberOfVariables = problem.getNumberOfVariables();
        int numberOfObjectives = problem.getNumberOfObjectives();
        if (reduced) {
            numberOfVariables = 0;
        }
        for (Solution solution : population) {
            int i;
            for (i = 0; i < numberOfVariables; ++i) {
                if (i > 0) {
                    writer.print(",");
                }
                if (solution.getVariable(i) instanceof RealVariable) {
                    writer.print(EncodingUtils.getReal(solution.getVariable(i)));
                    continue;
                }
                writer.print("?");
            }
            for (i = 0; i < numberOfObjectives; ++i) {
                if (i > 0 || numberOfVariables > 0) {
                    writer.print(",");
                }
                writer.print(solution.getObjective(i));
            }
            writer.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        Problem problem = null;
        boolean reduced = false;
        ArrayList<String> attributes = new ArrayList<String>();
        if (commandLine.hasOption("reduced")) {
            reduced = true;
        }
        if (commandLine.hasOption("names")) {
            String[] names;
            for (String name : names = commandLine.getOptionValue("names").split(",")) {
                attributes.add(name.trim());
            }
        }
        try {
            problem = commandLine.hasOption("problem") ? ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem")) : new ProblemStub(Integer.parseInt(commandLine.getOptionValue("dimension")));
            ResultFileReader reader = null;
            NondominatedPopulation population = null;
            try {
                reader = new ResultFileReader(problem, new File(commandLine.getOptionValue("input")));
                while (reader.hasNext()) {
                    population = reader.next().getPopulation();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            if (population.isEmpty()) {
                throw new FrameworkException("population is empty, can not generate ARFF file");
            }
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new FileWriter(commandLine.getOptionValue("output")));
                this.printHeader(problem, reduced, attributes, writer);
                this.printData(problem, reduced, population, writer);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (problem != null) {
                problem.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new ARFFConverter().start(args);
    }
}

