/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.moeaframework.analysis.sensitivity.ProblemStub;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileReader;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.util.CommandLineUtility;

public class AerovisConverter
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        group.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"dimension");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number");
        group.addOption(OptionBuilder.create((char)'d'));
        options.addOptionGroup(group);
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"reduced");
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"names");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'n'));
        return options;
    }

    private void printHeader(Problem problem, boolean reduced, List<String> attributes, PrintWriter writer) {
        int numberOfVariables = problem.getNumberOfVariables();
        int numberOfObjectives = problem.getNumberOfObjectives();
        if (reduced) {
            numberOfVariables = 0;
        }
        writer.println("# Nondominated Solutions:");
        writer.print("# Format:  Variables = ");
        writer.print(numberOfVariables);
        writer.print(" | Objectives = ");
        writer.println(numberOfObjectives);
        if (attributes.size() == numberOfObjectives) {
            int i;
            writer.print("# <DATA_HEADER>");
            for (i = 0; i < numberOfVariables; ++i) {
                writer.print(" Var");
                writer.print(i + 1);
            }
            for (i = 0; i < numberOfObjectives; ++i) {
                writer.print(" ");
                writer.print(attributes.get(i));
            }
            writer.println();
        } else if (attributes.size() == numberOfVariables + numberOfObjectives) {
            writer.print("# <DATA_HEADER>");
            for (int i = 0; i < numberOfVariables + numberOfObjectives; ++i) {
                writer.print(" ");
                writer.print(attributes.get(i));
            }
            writer.println();
        } else {
            int i;
            if (!attributes.isEmpty()) {
                System.err.println("incorrect number of names, using defaults");
            }
            writer.print("# <DATA_HEADER>");
            for (i = 0; i < numberOfVariables; ++i) {
                writer.print(" Var");
                writer.print(i + 1);
            }
            for (i = 0; i < numberOfObjectives; ++i) {
                writer.print(" Obj");
                writer.print(i + 1);
            }
            writer.println();
        }
        writer.println("# <GEN_HEADER> NFE, Time (sec)");
        writer.println("#");
    }

    private void convert(Problem problem, boolean reduced, ResultFileReader reader, PrintWriter writer) {
        int numberOfVariables = problem.getNumberOfVariables();
        int numberOfObjectives = problem.getNumberOfObjectives();
        if (reduced) {
            numberOfVariables = 0;
        }
        while (reader.hasNext()) {
            ResultEntry entry = reader.next();
            NondominatedPopulation population = entry.getPopulation();
            Properties properties = entry.getProperties();
            if (population.isEmpty()) continue;
            if (properties.containsKey("NFE")) {
                writer.print(properties.getProperty("NFE"));
            } else {
                writer.print("0");
            }
            writer.print(" ");
            if (properties.containsKey("ElapsedTime")) {
                writer.println(properties.getProperty("ElapsedTime"));
            } else {
                writer.println("0");
            }
            writer.println("#");
            for (Solution solution : population) {
                int i;
                for (i = 0; i < numberOfVariables; ++i) {
                    if (i > 0) {
                        writer.print(" ");
                    }
                    writer.print(solution.getVariable(i));
                }
                for (i = 0; i < numberOfObjectives; ++i) {
                    if (i > 0 || numberOfVariables > 0) {
                        writer.print(" ");
                    }
                    writer.print(solution.getObjective(i));
                }
                writer.println();
            }
            writer.println("#");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws Exception {
        Problem problem = null;
        ResultFileReader reader = null;
        PrintWriter writer = null;
        boolean reduced = false;
        ArrayList<String> attributes = new ArrayList<String>();
        if (commandLine.hasOption("reduced")) {
            reduced = true;
        }
        if (commandLine.hasOption("names")) {
            String[] names;
            for (String name : names = commandLine.getOptionValue("names").split(",")) {
                attributes.add(name.trim());
            }
        }
        try {
            problem = commandLine.hasOption("problem") ? ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem")) : new ProblemStub(Integer.parseInt(commandLine.getOptionValue("dimension")));
            try {
                reader = new ResultFileReader(problem, new File(commandLine.getOptionValue("input")));
                try {
                    writer = new PrintWriter(new FileWriter(commandLine.getOptionValue("output")));
                    this.printHeader(problem, reduced, attributes, writer);
                    this.convert(problem, reduced, reader, writer);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (problem != null) {
                problem.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new AerovisConverter().start(args);
    }
}

