/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.analysis.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.moeaframework.algorithm.PeriodicAction;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileWriter;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.operator.RandomInitialization;
import org.moeaframework.core.spi.AlgorithmFactory;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.ExternalProblem;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.io.FileUtils;

public class Solve
extends CommandLineUtility {
    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"problem");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"algorithm");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withLongOpt((String)"properties");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"p1=v1;p2=v2;...");
        OptionBuilder.withValueSeparator((char)';');
        options.addOption(OptionBuilder.create((char)'x'));
        OptionBuilder.withLongOpt((String)"seed");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"numberOfEvaluations");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withLongOpt((String)"runtimeFrequency");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'F'));
        OptionBuilder.withLongOpt((String)"variables");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"v1,v2,...");
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"objectives");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"constraints");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"lowerBounds");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"v1,v2,...");
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"upperBounds");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"v1,v2,...");
        options.addOption(OptionBuilder.create((char)'u'));
        OptionBuilder.withLongOpt((String)"useSocket");
        options.addOption(OptionBuilder.create((char)'S'));
        OptionBuilder.withLongOpt((String)"hostname");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'H'));
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withLongOpt((String)"startupDelay");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"value");
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withLongOpt((String)"test");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"trials");
        options.addOption(OptionBuilder.create((char)'t'));
        return options;
    }

    private Variable parseVariableSpecification(String token) throws ParseException {
        if (!token.endsWith(")")) {
            throw new ParseException("invalid variable specification '" + token + "', not properly formatted");
        }
        if (token.startsWith("R(")) {
            String content = token.substring(2, token.length() - 1);
            int index = content.indexOf(59);
            if (index >= 0) {
                double lowerBound = Double.parseDouble(content.substring(0, index));
                double upperBound = Double.parseDouble(content.substring(index + 1, content.length()));
                return EncodingUtils.newReal(lowerBound, upperBound);
            }
            throw new ParseException("invalid real specification '" + token + "', expected R(<lb>,<ub>)");
        }
        if (token.startsWith("B(")) {
            String content = token.substring(2, token.length() - 1);
            try {
                int length = Integer.parseInt(content.trim());
                return EncodingUtils.newBinary(length);
            }
            catch (NumberFormatException e) {
                throw new ParseException("invalid binary specification '" + token + "', expected B(<length>)");
            }
        }
        if (token.startsWith("P(")) {
            String content = token.substring(2, token.length() - 1);
            try {
                int length = Integer.parseInt(content.trim());
                return EncodingUtils.newPermutation(length);
            }
            catch (NumberFormatException e) {
                throw new ParseException("invalid permutation specification '" + token + "', expected P(<length>)");
            }
        }
        throw new ParseException("invalid variable specification '" + token + "', unknown type");
    }

    private List<Variable> parseVariables(CommandLine commandLine) throws ParseException {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (commandLine.hasOption("lowerBounds") && commandLine.hasOption("upperBounds")) {
            String[] upperBoundTokens;
            String[] lowerBoundTokens = commandLine.getOptionValue("lowerBounds").split(",");
            if (lowerBoundTokens.length != (upperBoundTokens = commandLine.getOptionValue("upperBounds").split(",")).length) {
                throw new ParseException("lower bound and upper bounds not the same length");
            }
            for (int i = 0; i < lowerBoundTokens.length; ++i) {
                double lowerBound = Double.parseDouble(lowerBoundTokens[i]);
                double upperBound = Double.parseDouble(upperBoundTokens[i]);
                variables.add(EncodingUtils.newReal(lowerBound, upperBound));
            }
        } else if (commandLine.hasOption("variables")) {
            String[] tokens;
            for (String token : tokens = commandLine.getOptionValue("variables").split(",")) {
                variables.add(this.parseVariableSpecification(token.trim().toUpperCase()));
            }
        } else {
            throw new ParseException("must specify either the problem, the variables, or the lower and upper bounds arguments");
        }
        return variables;
    }

    private Problem createExternalProblem(final CommandLine commandLine) throws ParseException, IOException {
        final int numberOfObjectives = Integer.parseInt(commandLine.getOptionValue("objectives"));
        final int numberOfConstraints = commandLine.hasOption("constraints") ? Integer.parseInt(commandLine.getOptionValue("constraints")) : 0;
        final List<Variable> variables = this.parseVariables(commandLine);
        if (commandLine.hasOption("useSocket")) {
            String hostname = null;
            int port = 16801;
            int delay = 1;
            if (commandLine.hasOption("hostname")) {
                hostname = commandLine.getOptionValue("hostname");
            }
            if (commandLine.hasOption("port")) {
                port = Integer.parseInt(commandLine.getOptionValue("port"));
            }
            if (commandLine.hasOption("startupDelay")) {
                delay = Integer.parseInt(commandLine.getOptionValue("startupDelay"));
            }
            if (commandLine.getArgs().length > 0) {
                System.out.print("Running ");
                System.out.println(StringUtils.join((Object[])commandLine.getArgs()));
                new ProcessBuilder(commandLine.getArgs()).start();
            }
            try {
                System.out.print("Sleeping for ");
                System.out.print(delay);
                System.out.println(" seconds");
                Thread.sleep(delay * 1000);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.out.println("Starting optimization");
            return new ExternalProblem(hostname, port){

                @Override
                public String getName() {
                    return StringUtils.join((Object[])commandLine.getArgs());
                }

                @Override
                public int getNumberOfVariables() {
                    return variables.size();
                }

                @Override
                public int getNumberOfObjectives() {
                    return numberOfObjectives;
                }

                @Override
                public int getNumberOfConstraints() {
                    return numberOfConstraints;
                }

                @Override
                public Solution newSolution() {
                    Solution solution = new Solution(variables.size(), numberOfObjectives, numberOfConstraints);
                    for (int i = 0; i < variables.size(); ++i) {
                        solution.setVariable(i, ((Variable)variables.get(i)).copy());
                    }
                    return solution;
                }
            };
        }
        return new ExternalProblem(commandLine.getArgs()){

            @Override
            public String getName() {
                return StringUtils.join((Object[])commandLine.getArgs());
            }

            @Override
            public int getNumberOfVariables() {
                return variables.size();
            }

            @Override
            public int getNumberOfObjectives() {
                return numberOfObjectives;
            }

            @Override
            public int getNumberOfConstraints() {
                return numberOfConstraints;
            }

            @Override
            public Solution newSolution() {
                Solution solution = new Solution(variables.size(), numberOfObjectives, numberOfConstraints);
                for (int i = 0; i < variables.size(); ++i) {
                    solution.setVariable(i, ((Variable)variables.get(i)).copy());
                }
                return solution;
            }
        };
    }

    private void runTests(Problem problem, CommandLine commandLine) {
        int trials = 5;
        if (commandLine.getOptionValue("test") != null) {
            trials = Integer.parseInt(commandLine.getOptionValue("test"));
        }
        try {
            Solution[] solutions;
            int count = 0;
            RandomInitialization initialization = new RandomInitialization(problem, trials);
            for (Solution solution : solutions = initialization.initialize()) {
                int j;
                System.out.println("Running test " + ++count + ":");
                for (j = 0; j < solution.getNumberOfVariables(); ++j) {
                    System.out.print("  Variable ");
                    System.out.print(j + 1);
                    System.out.print(" = ");
                    System.out.println(solution.getVariable(j));
                }
                System.out.println("  * Evaluating solution *");
                problem.evaluate(solution);
                System.out.println("  * Evaluation complete *");
                for (j = 0; j < solution.getNumberOfObjectives(); ++j) {
                    System.out.print("  Objective ");
                    System.out.print(j + 1);
                    System.out.print(" = ");
                    System.out.println(solution.getObjective(j));
                }
                for (j = 0; j < solution.getNumberOfConstraints(); ++j) {
                    System.out.print("  Constraint ");
                    System.out.print(j + 1);
                    System.out.print(" = ");
                    System.out.println(solution.getConstraint(j));
                }
                if (solution.getNumberOfConstraints() <= 0 || !solution.violatesConstraints()) continue;
                System.out.println("  Solution is infeasible (non-zero constraint value)!");
            }
            System.out.println("Test succeeded!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Test failed!  Please see the error message above for details.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine commandLine) throws IOException {
        Properties properties = new Properties();
        if (commandLine.hasOption("properties")) {
            for (String property : commandLine.getOptionValues("properties")) {
                String[] tokens = property.split("=");
                if (tokens.length != 2) {
                    throw new FrameworkException("malformed property argument");
                }
                properties.setProperty(tokens[0], tokens[1]);
            }
        }
        if (commandLine.hasOption("epsilon")) {
            properties.setProperty("epsilon", commandLine.getOptionValue("epsilon"));
        }
        int maxEvaluations = Integer.parseInt(commandLine.getOptionValue("numberOfEvaluations"));
        if (commandLine.hasOption("seed")) {
            PRNG.setSeed(Long.parseLong(commandLine.getOptionValue("seed")));
        }
        int runtimeFrequency = 100;
        if (commandLine.hasOption("runtimeFrequency")) {
            runtimeFrequency = Integer.parseInt(commandLine.getOptionValue("runtimeFrequency"));
        }
        Problem problem = null;
        Algorithm algorithm = null;
        ResultFileWriter writer = null;
        File file = new File(commandLine.getOptionValue("output"));
        try {
            problem = commandLine.hasOption("problem") ? ProblemFactory.getInstance().getProblem(commandLine.getOptionValue("problem")) : this.createExternalProblem(commandLine);
            if (commandLine.hasOption("test")) {
                this.runTests(problem, commandLine);
                return;
            }
            try {
                algorithm = AlgorithmFactory.getInstance().getAlgorithm(commandLine.getOptionValue("algorithm"), properties, problem);
                FileUtils.delete(file);
                try {
                    writer = new ResultFileWriter(problem, file);
                    algorithm = new RuntimeCollector(algorithm, runtimeFrequency, writer);
                    while (!algorithm.isTerminated() && algorithm.getNumberOfEvaluations() < maxEvaluations) {
                        algorithm.step();
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            finally {
                if (algorithm != null) {
                    algorithm.terminate();
                }
            }
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        finally {
            if (problem != null) {
                problem.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new Solve().start(args);
    }

    private static class RuntimeCollector
    extends PeriodicAction {
        private final ResultFileWriter writer;
        private final long startTime;

        public RuntimeCollector(Algorithm algorithm, int frequency, ResultFileWriter writer) {
            super(algorithm, frequency, PeriodicAction.FrequencyType.EVALUATIONS);
            this.writer = writer;
            this.startTime = System.nanoTime();
        }

        @Override
        public void doAction() {
            double elapsedTime = (double)(System.nanoTime() - this.startTime) * 1.0E-9;
            NondominatedPopulation result = this.algorithm.getResult();
            Properties properties = new Properties();
            properties.setProperty("NFE", Integer.toString(this.algorithm.getNumberOfEvaluations()));
            properties.setProperty("ElapsedTime", Double.toString(elapsedTime));
            try {
                this.writer.append(new ResultEntry(result, properties));
            }
            catch (IOException e) {
                throw new FrameworkException(e);
            }
        }
    }
}

