/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;

public class AdaptiveGridArchive
extends NondominatedPopulation {
    protected final int capacity;
    protected final Problem problem;
    protected final int numberOfDivisions;
    protected double[] minimum;
    protected double[] maximum;
    protected int[] density;

    public AdaptiveGridArchive(int capacity, Problem problem, int numberOfDivisions) {
        super((DominanceComparator)new ParetoDominanceComparator(), NondominatedPopulation.DuplicateMode.ALLOW_DUPLICATES);
        this.capacity = capacity;
        this.problem = problem;
        this.numberOfDivisions = numberOfDivisions;
        this.minimum = new double[problem.getNumberOfObjectives()];
        this.maximum = new double[problem.getNumberOfObjectives()];
        try {
            this.density = new int[ArithmeticUtils.pow((int)numberOfDivisions, (int)problem.getNumberOfObjectives())];
        }
        catch (MathArithmeticException e) {
            throw new FrameworkException("number of divisions (bisections) too large for adaptive grid archive", e);
        }
        this.adaptGrid();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getNumberOfDivisions() {
        return this.numberOfDivisions;
    }

    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public boolean add(Solution solution) {
        Iterator<Solution> iterator = this.iterator();
        while (iterator.hasNext()) {
            Solution oldSolution = iterator.next();
            int flag = this.comparator.compare(solution, oldSolution);
            if (flag < 0) {
                iterator.remove();
                continue;
            }
            if (flag <= 0) continue;
            return false;
        }
        if (this.isEmpty()) {
            super.forceAddWithoutCheck(solution);
            this.adaptGrid();
            return true;
        }
        super.forceAddWithoutCheck(solution);
        int index = this.findIndex(solution);
        if (index < 0) {
            this.adaptGrid();
            index = this.findIndex(solution);
        } else {
            int n = index;
            this.density[n] = this.density[n] + 1;
        }
        if (this.size() <= this.capacity) {
            return true;
        }
        if (this.density[index] == this.density[this.findDensestCell()]) {
            this.remove(solution);
            return false;
        }
        this.remove(this.pickSolutionFromDensestCell());
        return true;
    }

    @Override
    public void remove(int index) {
        int gridIndex = this.findIndex(this.get(index));
        super.remove(index);
        if (this.density[gridIndex] > 1) {
            int n = gridIndex;
            this.density[n] = this.density[n] - 1;
        } else {
            this.adaptGrid();
        }
    }

    @Override
    public boolean remove(Solution solution) {
        boolean removed = super.remove(solution);
        if (removed) {
            int index = this.findIndex(solution);
            if (this.density[index] > 1) {
                int n = index;
                this.density[n] = this.density[n] - 1;
            } else {
                this.adaptGrid();
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        super.clear();
        this.adaptGrid();
    }

    protected int findDensestCell() {
        int index = -1;
        int value = -1;
        for (int i = 0; i < this.size(); ++i) {
            int tempIndex = this.findIndex(this.get(i));
            int tempValue = this.density[tempIndex];
            if (tempValue <= value) continue;
            value = tempValue;
            index = tempIndex;
        }
        return index;
    }

    protected Solution pickSolutionFromDensestCell() {
        Solution solution = null;
        int value = -1;
        for (int i = 0; i < this.size(); ++i) {
            int tempValue = this.density[this.findIndex(this.get(i))];
            if (tempValue <= value) continue;
            solution = this.get(i);
            value = tempValue;
        }
        return solution;
    }

    protected void adaptGrid() {
        Arrays.fill(this.minimum, Double.POSITIVE_INFINITY);
        Arrays.fill(this.maximum, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.density, 0);
        for (Solution solution : this) {
            for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                this.minimum[i] = Math.min(this.minimum[i], solution.getObjective(i));
                this.maximum[i] = Math.max(this.maximum[i], solution.getObjective(i));
            }
        }
        for (Solution solution : this) {
            int n = this.findIndex(solution);
            this.density[n] = this.density[n] + 1;
        }
    }

    public int findIndex(Solution solution) {
        int index = 0;
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            double value = solution.getObjective(i);
            if (value < this.minimum[i] || value > this.maximum[i]) {
                return -1;
            }
            int tempIndex = (int)((double)this.numberOfDivisions * ((value - this.minimum[i]) / (this.maximum[i] - this.minimum[i])));
            if (tempIndex == this.numberOfDivisions) {
                --tempIndex;
            }
            index += tempIndex * ArithmeticUtils.pow((int)this.numberOfDivisions, (int)i);
        }
        return index;
    }

    public int getDensity(int index) {
        return this.density[index];
    }
}

