/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.util.Iterator;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.EpsilonBoxDominanceComparator;

public class EpsilonBoxDominanceArchive
extends NondominatedPopulation {
    private int numberOfImprovements;
    private int numberOfDominatingImprovements;

    public EpsilonBoxDominanceArchive(double epsilon) {
        super(new EpsilonBoxDominanceComparator(epsilon));
    }

    public EpsilonBoxDominanceArchive(double epsilon, Iterable<? extends Solution> iterable) {
        super((DominanceComparator)new EpsilonBoxDominanceComparator(epsilon), iterable);
    }

    public EpsilonBoxDominanceArchive(double[] epsilon) {
        super(new EpsilonBoxDominanceComparator(epsilon));
    }

    public EpsilonBoxDominanceArchive(double[] epsilon, Iterable<? extends Solution> iterable) {
        super((DominanceComparator)new EpsilonBoxDominanceComparator(epsilon), iterable);
    }

    public EpsilonBoxDominanceArchive(EpsilonBoxDominanceComparator comparator) {
        super(comparator);
    }

    public EpsilonBoxDominanceArchive(EpsilonBoxDominanceComparator comparator, Iterable<? extends Solution> iterable) {
        super((DominanceComparator)comparator, iterable);
    }

    @Override
    public boolean add(Solution newSolution) {
        Iterator<Solution> iterator = this.iterator();
        boolean same = false;
        boolean dominates = false;
        while (iterator.hasNext()) {
            Solution oldSolution = iterator.next();
            int flag = this.getComparator().compare(newSolution, oldSolution);
            if (flag < 0) {
                if (this.getComparator().isSameBox()) {
                    same = true;
                } else {
                    dominates = true;
                }
                iterator.remove();
                continue;
            }
            if (flag <= 0) continue;
            return false;
        }
        if (!same) {
            ++this.numberOfImprovements;
            if (dominates) {
                ++this.numberOfDominatingImprovements;
            }
        }
        return this.forceAddWithoutCheck(newSolution);
    }

    @Override
    public EpsilonBoxDominanceComparator getComparator() {
        return (EpsilonBoxDominanceComparator)super.getComparator();
    }

    public int getNumberOfImprovements() {
        return this.numberOfImprovements;
    }

    public int getNumberOfDominatingImprovements() {
        return this.numberOfDominatingImprovements;
    }
}

