/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.util.ArrayList;
import java.util.List;
import org.moeaframework.core.NondominatedSorting;
import org.moeaframework.core.Population;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;

public class FastNondominatedSorting
extends NondominatedSorting {
    public FastNondominatedSorting() {
    }

    public FastNondominatedSorting(DominanceComparator comparator) {
        super(comparator);
    }

    @Override
    public void evaluate(Population population) {
        int N = population.size();
        int[][] dominanceChecks = new int[N][N];
        for (int i = 0; i < N; ++i) {
            Solution si = population.get(i);
            for (int j = i + 1; j < N; ++j) {
                if (i == j) continue;
                Solution sj = population.get(j);
                dominanceChecks[i][j] = this.comparator.compare(si, sj);
                dominanceChecks[j][i] = -dominanceChecks[i][j];
            }
        }
        int[] dominatedCounts = new int[N];
        ArrayList dominatesList = new ArrayList();
        ArrayList<Integer> currentFront = new ArrayList<Integer>();
        for (int i = 0; i < N; ++i) {
            ArrayList<Integer> dominates = new ArrayList<Integer>();
            int dominatedCount = 0;
            for (int j = 0; j < N; ++j) {
                if (i == j) continue;
                if (dominanceChecks[i][j] < 0) {
                    dominates.add(j);
                    continue;
                }
                if (dominanceChecks[j][i] >= 0) continue;
                ++dominatedCount;
            }
            if (dominatedCount == 0) {
                currentFront.add(i);
            }
            dominatesList.add(dominates);
            dominatedCounts[i] = dominatedCount;
        }
        int rank = 0;
        while (!currentFront.isEmpty()) {
            ArrayList<Integer> nextFront = new ArrayList<Integer>();
            Population solutionsInFront = new Population();
            for (int i = 0; i < currentFront.size(); ++i) {
                Solution solution = population.get((Integer)currentFront.get(i));
                solution.setAttribute("rank", Integer.valueOf(rank));
                for (Integer j : (List)dominatesList.get((Integer)currentFront.get(i))) {
                    int n = j;
                    dominatedCounts[n] = dominatedCounts[n] - 1;
                    if (dominatedCounts[j] != 0) continue;
                    nextFront.add(j);
                }
                solutionsInFront.add(solution);
            }
            this.updateCrowdingDistance(solutionsInFront);
            ++rank;
            currentFront = nextFront;
        }
    }
}

